
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  Routine      put
*
*  Description: Makes code word and write it to output bitstream 
*               Input: length and info part of a codeword 
*               
*               A code word has the following format: 0 Xn...0 X2 0 X1 0 X0 1
*               Info   : Xn..X2 X1 X0
*               Length : Total number of bits in the codeword    
*               
*
************************************************************************/ 
#include <stdio.h>
#include "global.h"
#include "stream.h"


void put(int len,int info)
{
    int i;
    static byte active_bitpos=0x80;    /* start writing to MSB */
    static byte outbyte=0x00;          /* data of byte currently being filled */
    static int bytecount=0;            /* active byte in buffer */
    static int bitcount=0;             /* active bit in buffer */
    static byte outbuf[MAX_FILELEN];   /* store the hole stream, write 
                                          to file at the end */

    if (bitcount == 0)                      /* add 2 empty bytes in the start of the file ('future use') */
    {
        outbuf[0]=0x00;
        outbuf[1]=0x00;
        bytecount+=2;
        bitcount+=16;
    }
    
    if (len == 0)                           /* finish, write buffer to file */
    {
        int stuffing=0xff;
        while (stuffing>active_bitpos)
            stuffing=stuffing>>1;  
        outbuf[bytecount-1] |=stuffing;     /* stuff unused bit pos in the last byte with 1 for byte alignment */
        
        for (i=0; i < bytecount; i++) 
        {
            fputc(outbuf[i],p_out);
        }
        return;
    }
        
    for (i=0;i<len/2;i++)
    {
        outbyte=outbyte & ~active_bitpos;          /* set odd bit positions to 0 (ref VLC) */
        if ((active_bitpos=active_bitpos>>1) <= 0) /* check if byte is full */
        {
            active_bitpos=0x80;                    /* bit pos 8, first bit positions */
            outbuf[bytecount++]=outbyte;           /* over byte boundary,write byte to buffer */     
            outbyte=0;
        }
        if (0x01 & ( info >> (len/2-i-1)))
            outbyte=(outbyte | active_bitpos) ;    /* add info part to codeword */
        
        if ((active_bitpos=active_bitpos>>1) <= 0) /* check again if byte is full */
        {
            active_bitpos=0x80;                    /* bit pos 8 */
            outbuf[bytecount++]=outbyte;           /* over byte boundary,write byte to buffer */
            outbyte=0;
        }
    }    

    /*## <Sharp Start> ##*/

    /*## in case of 2-1-2 VLC code, skip the last bit '1' ##*/ 

    if(len!=2){
       outbyte=outbyte | active_bitpos;               /* set last bit in info word to 1  (ref VLC)  */ 
       if ((active_bitpos=active_bitpos>>1) <= 0)
       {
           active_bitpos=0x80;                        /* bit pos 8 */ 
           outbuf[bytecount++]=outbyte;               /* over byte boundary,write byte to buffer */ 
           outbyte=0;
       }
    }

    /*## <Sharp End> ##*/

    bitcount += len; 
}

