
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  lencoder.c
*  Main program for H.26L encoder
*  Copyright (C) 1999  Telenor Satellite Services,Norway
*  Copyright (C) 1999  Tandberg Telecom A.S.,Norway
*  
*  Contacts: 
*  Inge Lille-Langy               <Inge.Lille-Langoy@international.telenor.no>
*
*  Telenor Satellite Services 
*  Keysers gt.13                        tel.:   +47 23 13 86 98
*  N-0130 Oslo,Norway                  fax.:   +47 22 77 79 80
*
*  Tom-Ivar Johansen               <tij@tandberg.no>
*
*  Tandberg Telecom A.S.                tel.:   +47 67 117 743
*  Philip Pedersens v. 22                       +47 67 125 125
*  N-1374 Lysaker,Norway               fax.:   +47 67 125 234
*
************************************************************************/



#include <string.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <sys/timeb.h>
#include <stdlib.h>


#include "global.h"            /*## all head files are changed to be local files ##*/

void main(int argc,char **argv)
{
    FILE *fd;
    char config_filename[100];
    int bit_use[2][2] ;
    int i,j,k;
    int mb_width,mb_height;
    int avg_search_pos;       /*## average subpixel searching positions ##*/
    
    time_t ltime1;                  /* for time measurement */
    time_t ltime2;
    struct timeb tstruct1;
    struct timeb tstruct2;
    char timebuf[128];
    int tot_time=0;                 /* time for total encoding session */
    int tmp_time;
    
    struct inp_par    *inp;         /* input parameters from input configuration file */
    struct stat_par   *stat;        /* statistics */
    struct snr_par    *snr;  
    struct img_par    *img;

    /* allocate memory */
    inp =  (struct inp_par *) calloc(1, sizeof(struct inp_par)); 
    stat = (struct stat_par *)calloc(1, sizeof(struct stat_par));
    snr =  (struct snr_par *) calloc(1, sizeof(struct snr_par));
    img =  (struct img_par *) calloc(1, sizeof(struct img_par));
    
    if (argc != 2) 
    {
        printf("Usage: %s <config.dat> \n",argv[0]);
        printf("<config.dat> defines encoder parameters\n");
        exit(-1);
    }
    strcpy(config_filename,argv[1]);
    
    if((fd=fopen(config_filename,"r")) == NULL)         /* read the decoder configuration file */
    {
        printf("Error: Control file %s not found\n",config_filename);
        exit(0);
    }

    /* read input parameters */
    fscanf(fd,"%ld,",&inp->no_frames);                  /* number of frames to be encoded */
    fscanf(fd,"%*[^\n]");                               /* discard everything to the beginning of ewnt line */
    
    fscanf(fd,"%ld,",&inp->quant_0);                    /* QP of first frame (max 31) */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->quant_n);                    /* QP of remaining frames (max 31) */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->jumpd);                      /* number of frames to skip in input sequence (e.g 2 takes frame 0,3,6,9...) */ 
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->hadamard);                   /* 0: 'normal' SAD in 1/2 and 1/3 pixel search.  1: use 4x4 Hadamard transform and 'Sum of absolute transform differens' in 1/2 and 1/3 pixel search */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->mcrange);                    /* search range-integer pel search and 16x16 blocks.  The search window is generally around the predicted vector. Max vector is 2xmcrange.  For 8x8 and 4x4 block sizes the search range is 1/2 of that for 16x16 blocks. */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->no_multpred);                /* 1: prediction from the last frame only. 2: prediction from the last or second last frame etc.  Maximum 5 frames */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->postfilter);                 /* 0: No inp->postfilter.  1: use inp->postfilter. */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->img_format);                 /* 0: QCIF. 1: CIF. */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%ld,",&inp->intra_upd);                  /* For error robustness. 
                                                            0: no special action. 
                                                            1: One GOB/frame is intra coded as regular 'update'. 
                                                            2: One GOB every 2 frames is intra coded etc.  
                                                            In connection with this intra update,restrictions is put on 
                                                            motion vectors to prevent errors to propagate from the past */                                                         
    fscanf(fd,"%*[^\n]");
    fscanf(fd,"%ld,",&inp->write_dec);                  /*  0: Do not write decoded image to file  
                                                            1: Write decoded image to file */
    fscanf(fd,"%*[^\n]");

    /* decide block sizes */

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[1][0]=16;
        img->mhv[1][1]=16;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[2][0]=16;
        img->mhv[2][1]= 8;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[3][0]= 8;
        img->mhv[3][1]=16;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[4][0]= 8;
        img->mhv[4][1]= 8;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[5][0]= 8;
        img->mhv[5][1]= 4;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[6][0]= 4;
        img->mhv[6][1]= 8;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%ld,",&inp->bck_tmp);
    if (inp->bck_tmp)
    {
        img->mhv[7][0]= 4;
        img->mhv[7][1]= 4;
    }
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%s",inp->infile);                        /* YUV 4:2:2 input format */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%s",inp->outfile);                       /* H.26L compressed output bitsream */
    
    if ((p_in=fopen(inp->infile,"rb"))==0)
    {
        printf("Input file %s does not exist \n",inp->infile);
        exit(0);
    }

    if ((p_out=fopen(inp->outfile,"wb"))==0)            /* bitstream */
    {
        printf("Error open file %s  \n",inp->outfile);
        exit(0);
    }    

    if ((p_dec=fopen("test.dec","wb"))==0)              /* decodet picture,for debugging */
    {
        printf("Error open file test.dec \n");
        exit(0);
    }
    
    printf("--------------------------------------------------------------------------\n");
    printf(" Encoder config file               : %s \n",config_filename);
    printf("--------------------------------------------------------------------------\n");
    printf(" Input YUV file                    : %s \n",inp->infile);
    printf(" Output H.26L bitstream            : %s \n",inp->outfile);
    if (inp->write_dec)
        printf(" Output YUV file(debug)            : test.dec \n");
    printf(" Output log file                   : log.dat \n");
    printf(" Output statistics file            : stat.dat \n");
    printf("--------------------------------------------------------------------------\n");
    
    
    img->framerate=INIT_FRAME_RATE;                     /* The basic frame rate (of the original sequence) */
    
    if (inp->img_format == QCIF)
    {
        mb_width = 11;
        mb_height=  9;
    } 
    else if (inp->img_format == CIF) 
    {
        mb_width = 22;
        mb_height= 18;
    }
    else
    {
        printf("Unsupported image format=%d,use QCIF=0 or CIF=1 \n",inp->img_format);
        exit(0);
    }
    
    img->img_width    = mb_width * MB_SIZE;
    img->img_width_cr = mb_width * MB_SIZE/2;
    img->img_height   = mb_height* MB_SIZE;
    img->img_height_cr= mb_height* MB_SIZE/2;
    img->impix        = img->img_height*img->img_width;
    
    init();
    
    /* Prediction mode is set to -1 outside the frame, indicating that no prediction can be made from this part*/
    
    for (i=0; i < img->img_width/4+1; ++i) 
    {
        predmode[i+1][0]=-1;
    }
    for (j=0; j < img->img_height/4+1; ++j) 
    {
        predmode[0][j+1]=-1;
    }
    
    /*## add more items in the title ##*/

    printf("Frame  Bit/pic  QP   SnrY    SnrU    SnrU    Bitrate  Time(ms)  1/2-pixel 1/3 pixel 1/6 pixel AvgSearchPos\n");

    img->LineMb_upd=0;
    
    for (img->pic_no=0; img->pic_no < inp->no_frames; ++img->pic_no) 
    {
        ftime( &tstruct1 );     /* start time ms */  
        time( &ltime1 );        /* start time s  */
      
        /*## <Sharp Start> ##*/

        /*## initialize motion accuracy mode counters ##*/
        for(i=0;i<4;i++)
           img->accuracy_count[i]=0;

        /*## initialize the counter for average subpixel searching positions ##*/
        total_blocks=0;
        total_search_position=0;

        /*## <Sharp End> ##*/

        image(img,inp,stat);     
        
        /*  Loopfilter is only performed for intra frames */
        
        if (img->pic_type == INTRA_IMG) 
        {
            loopfilter(img);
        }
       
        img->np0=img->pic_no % MAX_MULT_PRED;
        
        /*## <Sharp Start> ##*/

        /*##  
          use 1/2 pixel upsampling instead of 1/3 pixel upsampling to
          save cache memory. The upsampled reference frame is used for 
          1/2 pixel motion search. For 1/3 pixel motion search and motion 
          compensation, we use on-line interpolated value.
        ##*/

        halfpix(img,inp);

        /*## <Sharp End> ##*/
        
        if (inp->postfilter == 1) 
        {
            postfilter(img); 
        }
        else if (inp->postfilter != 0)
        {
            printf("Error : Input parameter postfilter, check configuration file\n");
            exit(0);
        }

        find_snr(snr,img);
        
        if (inp->write_dec) /* write decoded image to file, just for debugging */
        {
            
            for (i=0; i < img->img_height; i++) 
            {
                for (j=0; j < img->img_width; j++) 
                {
                    fputc(mmin(imgY[j][i][1],255),p_dec);
                }
            }
 
            for (k=0; k < 2; ++k) 
            {
                for (i=0; i < img->img_height/2; i++) 
                {
                    for (j=0; j < img->img_width/2; j++) 
                    {
                        fputc(mmin(imgUV[j][i][1][k],255),p_dec);
                    }
                }
            }
        }
        
        time( &ltime2 );                    /* end time sec */
        ftime( &tstruct2 );                 /* end time ms  */
        tmp_time=(ltime2*1000+tstruct2.millitm) - (ltime1*1000+tstruct1.millitm);
        tot_time=tot_time + tmp_time;
        
        /*  Output to terminal */
        
        stat->bitr= (float)stat->bit_ctr_0*img->framerate/(inp->no_frames*(inp->jumpd+1)) + 
            stat->bit_ctr*img->framerate/((img->pic_no+1)*(inp->jumpd+1));
        
        /*## <Sharp Start> ##*/

        /*## calculate the average subpixel searching positions ##*/
        avg_search_pos=(total_blocks==0)?0:(total_search_position/total_blocks);

        /*## add more items to the output ##*/
        printf(" %2d %8d %5d %7.3f %7.3f %7.3f  %8.0f %5d %8d %8d %8d %8d\n",
                img->pic_no*(inp->jumpd+1), stat->bit_ctr-stat->bit_ctr_n,
                img->quant, snr->snr_y, snr->snr_u, snr->snr_v, stat->bitr,
                tmp_time,img->accuracy_count[HALF],img->accuracy_count[ONE_THIRD],
                img->accuracy_count[ONE_SIXTH],avg_search_pos);

        /*## <Sharp End> ##*/

        if (img->pic_no == 0) 
        {
            stat->bitr0=stat->bitr;         /* store bitrate for first frame */
            stat->bit_ctr_0=stat->bit_ctr;  /* store bit usage for first frame */
            stat->bit_ctr=0;                  
        }
        stat->bit_ctr_n=stat->bit_ctr;      /* store last bit usage */
    }
    
    /*  write End Of Sequence and output bit array to file */
    
    put(LEN_STARTCODE,1);
    put(9,0xff);              /* be shure the last byte is filled */
    put(0,0);                 /* signal end of sequence */
    
    bit_use[0][0]=1;
    
    bit_use[1][0]=mmax(1,inp->no_frames-1);
    
    /*  Accumulate bit usage for inter and intra frames */
    
    for (j=0; j <= 1; ++j) 
    {
        bit_use[j][1]=0;
        for (i=0; i <= 11; ++i) 
        {
            bit_use[j][1] += tmp_bit_use[i][j];
        }
    }
    if (inp->no_frames > 1) 
    {
        stat->bitrate=(bit_use[0][1]+bit_use[1][1])*(float)img->framerate/(inp->no_frames*(inp->jumpd+1));
    }
    
    fprintf(stdout,"--------------------------------------------------------------------------\n");    
    fprintf(stdout,   " Freq. for encoded bitstream       : %1.0f\n",(float)img->framerate/(float)(inp->jumpd+1));
    if(inp->hadamard)
        fprintf(stdout," Hadamard transform                : Used\n");
    else
        fprintf(stdout," Hadamard transform                : Not used\n");
    
    if(inp->postfilter)
        fprintf(stdout," Postfilter                        : Used\n");
    else
        fprintf(stdout," Postfilter                        : Not used\n");
    
    if(inp->img_format==0)
        fprintf(stdout," Image format                      : QCIF\n");
    else if(inp->img_format==1)
        fprintf(stdout," Image format                      : CIF\n");
    
    
    if(inp->intra_upd)
        fprintf(stdout," Error robustness                  : On\n");
    else if(inp->img_format==1)
        fprintf(stdout," Error robustness                  : Off\n");
    
    fprintf(stdout,   " Search range                      : %d\n",inp->mcrange);
    
    
    fprintf(stdout,   " No of ref. frames used in pred    : %d\n",inp->no_multpred);
    
    fprintf(stdout,   " Total encoding time for the seq.  : %d\n",tot_time);
 
    fprintf(stdout,"------------------ Average data all frames  ------------------------------\n");
    fprintf(stdout," SNR Y(dB)                         : %5.2f\n",snr->snr_ya);
    fprintf(stdout," SNR U(dB)                         : %5.2f\n",snr->snr_ua);
    fprintf(stdout," SNR V(dB)                         : %5.2f\n",snr->snr_va);
    fprintf(stdout," Bit usage                         : %5.2f\n",(float)(bit_use[1][1]+bit_use[0][1])/img->pic_no);
    fprintf(stdout," Bit rate                          : %5.2f\n",stat->bitrate);
    fprintf(stdout,"--------------------------------------------------------------------------\n");    
    fprintf(stdout,"Exit encoder, Telenor H.26L proposal, version 1.0\n");            
    
    /* 
        status file 
    */
    if ((p_stat=fopen("stat.dat","wb"))==0)
    {
        printf("Error open file %s  \n",p_stat);
        exit(0);
    }    
    fprintf(p_stat," -------------------------------------------------------------- \n");    
    fprintf(p_stat,"  This file contains statistics for the last encoded sequence   \n");
    fprintf(p_stat," -------------------------------------------------------------- \n");    
    fprintf(p_stat,   " Sequence                     : %s\n",inp->infile);
    fprintf(p_stat,   " No.of coded pictures         : %d\n",inp->no_frames);
    fprintf(p_stat,   " Freq. for encoded bitstream  : %3.0f\n",(float)img->framerate/(float)(inp->jumpd+1));
    fprintf(p_stat,   " Bitate(kb/s)                 : %6.2f\n",stat->bitrate);
    
    if(inp->hadamard)
        fprintf(p_stat," Hadamard transform           : Used\n");
    else
        fprintf(p_stat," Hadamard transform           : Not used\n");
    
    if(inp->postfilter)
        fprintf(p_stat," Postfilter                   : Used\n");
    else
        fprintf(p_stat," Postfilter                   : Not used\n");
    
    if(inp->img_format==0)
        fprintf(p_stat," Image format                 : QCIF\n");
    else if(inp->img_format==1)
        fprintf(p_stat," Image format                 : CIF\n");
    
    if(inp->intra_upd)
        fprintf(p_stat," Error robustness             : On\n");
    else if(inp->img_format==1)
        fprintf(p_stat," Error robustness             : Off\n");
    
    fprintf(p_stat,   " Search range                 : %d\n",inp->mcrange);    
    fprintf(p_stat,   " No of frame used in pred     : %d\n",inp->no_multpred);

    fprintf(p_stat," ---------------|---------------|---------------|\n");
    fprintf(p_stat," Item           |   1. Frame    |  All frames   |\n");
    fprintf(p_stat," ---------------|---------------|---------------|\n");
    fprintf(p_stat," SNR Y(dB)      |");
    fprintf(p_stat," %5.2f         |",snr->snr_y1);
    fprintf(p_stat," %5.2f         |\n",snr->snr_ya);
    fprintf(p_stat," SNR U/V (dB)   |");
    fprintf(p_stat," %5.2f/%5.2f   |",snr->snr_u1,snr->snr_v1);
    fprintf(p_stat," %5.2f/%5.2f   |\n",snr->snr_ua,snr->snr_va);  
    /*     QUANT. */
    fprintf(p_stat," Average quant  |");
    fprintf(p_stat," %5d         |",abs(inp->quant_0));
    fprintf(p_stat," %5.2f         |",(float)stat->quant1/mmax(1.0,(float)stat->quant0));    
    /*     MODE */   
       
    fprintf(p_stat,"\n Mode 0  (copy) | %5d         | %5d         |",vectmode_use[0][0]/bit_use[0][0],vectmode_use[1][0]/bit_use[1][0]);        
    fprintf(p_stat,"\n Mode 1  (16x16)| %5d         | %5d         |",vectmode_use[0][1]/bit_use[0][0],vectmode_use[1][1]/bit_use[1][0]);        
    fprintf(p_stat,"\n Mode 2  (16x8) | %5d         | %5d         |",vectmode_use[0][2]/bit_use[0][0],vectmode_use[1][2]/bit_use[1][0]);              
    fprintf(p_stat,"\n Mode 3  (8x16) | %5d         | %5d         |",vectmode_use[0][3]/bit_use[0][0],vectmode_use[1][3]/bit_use[1][0]);        
    fprintf(p_stat,"\n Mode 4  (8x8)  | %5d         | %5d         |",vectmode_use[0][4]/bit_use[0][0],vectmode_use[1][4]/bit_use[1][0]);              
    fprintf(p_stat,"\n Mode 5  (8x4)  | %5d         | %5d         |",vectmode_use[0][5]/bit_use[0][0],vectmode_use[1][5]/bit_use[1][0]);        
    fprintf(p_stat,"\n Mode 6  (4x8)  | %5d         | %5d         |",vectmode_use[0][6]/bit_use[0][0],vectmode_use[1][6]/bit_use[1][0]);              
    fprintf(p_stat,"\n Mode 7  (4x4)  | %5d         | %5d         |",vectmode_use[0][7]/bit_use[0][0],vectmode_use[1][7]/bit_use[1][0]);        
    fprintf(p_stat,"\n Mode 9  (intra)| %5d         | %5d         |",vectmode_use[0][9]/bit_use[0][0],vectmode_use[1][9]/bit_use[1][0]);              
  
    fprintf(p_stat,"\n");    
    /*     BITS. */    
    fprintf(p_stat," ---------------|---------------|---------------|\n");
    fprintf(p_stat," Bit usage:     |               |               |\n");
    fprintf(p_stat," ---------------|---------------|---------------|\n");
    fprintf(p_stat," Header+modeinfo|");
    for (j=0; j <= 1; ++j) 
    {
        fprintf(p_stat," %5d         |",tmp_bit_use[0][j]/bit_use[j][0]);
    }
        
    for (i=1; i < 8; ++i)     
    {   fprintf(p_stat,"\n Vectors mode %2d|",i);
        for (j=0; j <= 1; ++j) 
        {
            fprintf(p_stat," %5.0f         |",(float)tmp_bit_use[i][j]/(float)bit_use[j][0]);
        }
        
    }
    fprintf(p_stat,"\n");
    fprintf(p_stat," CBP Y/C mode 9 |");
    for (j=0; j <= 1; ++j) 
    {
        fprintf(p_stat," %5d         |",tmp_bit_use[9][j]/bit_use[j][0]);
    }
    fprintf(p_stat,"\n");
    
        /* bit usage for coeffisients */
    fprintf(p_stat," Coeffs. Y      | %7d       | %7d       |\n",tmp_bit_use[10][0]/bit_use[0][0],tmp_bit_use[10][1]/bit_use[1][0]);
    fprintf(p_stat," Coeffs. C      | %7d       | %7d       |\n",tmp_bit_use[11][0]/bit_use[0][0],tmp_bit_use[11][1]/bit_use[1][0]);   fprintf(p_stat," ---------------|---------------|---------------|\n");
    fprintf(p_stat," Total pr.pict. |");
    for (i=0; i <= 1; ++i) 
    {
        fprintf(p_stat," %5d         |",bit_use[i][1]/bit_use[i][0]);
    }
    fprintf(p_stat,"\n");
    fprintf(p_stat," ---------------|---------------|---------------|\n");
    

    /*
        write to log file
    */
    if (fopen("log.dat","r")==0)                        /* check if file exist */
    {
        if ((p_log=fopen("log.dat","a"))==0)            /* append new statistic at the end */
        {
            printf("Error open file %s  \n",p_log);
            exit(0);
        }
        else                                            /* Create header for new log file */
        {
            fprintf(p_log," -------------------------------------------------------------------------------------------------------------------------------------------------------------------------- \n");
            fprintf(p_log,"|            Encoder statistics. This file is made first time the encoder is used, later new runs will be appended                                                         |\n");  
            fprintf(p_log," -------------------------------------------------------------------------------------------------------------------------------------------------------------------------- \n");
            fprintf(p_log,"| Date  | Time  |    Sequence        |#Img|Quant1|QuantN|Format|Hadamard|Search r|#Pred|Postfiler|#Skip|Intra upd|SNRY 1|SNRU 1|SNRV 1|SNRY N|SNRU N|SNRV N|#Bitr 1|#Bitr N|\n");
            fprintf(p_log," -------------------------------------------------------------------------------------------------------------------------------------------------------------------------- \n");
        }
    }
    else 
        p_log=fopen("log.dat","a");                     /* File exist,just open for appending */                      
    
    /*## 
       the following two functions are not compatible to my compiler,
       so, I simply commented them . 
    ##*/

    /*##
    _strdate( timebuf );    
    fprintf(p_log,"| %1.5s |",timebuf );
    
    _strtime( timebuf);    
    fprintf(p_log," % 1.5s |",timebuf);
    
    ##*/

    fprintf(p_log,"%20.20s|",inp->infile);
    
    fprintf(p_log,"%3d |",inp->no_frames);
    fprintf(p_log,"  %2d  |",inp->quant_0);
    fprintf(p_log,"  %2d  |",inp->quant_n);    
    if(inp->img_format==0)
        fprintf(p_log," QCIF |");
    else
        fprintf(p_log," CIF  |");
    
    if (inp->hadamard==1)
        fprintf(p_log,"   ON   |");
    else
        fprintf(p_log,"   OFF  |");
    
    fprintf(p_log,"   %2d   |",inp->mcrange ); /* search range */
    fprintf(p_log," %2d  |",inp->no_multpred); /* mult pred */
    
    if (inp->postfilter==1)
        fprintf(p_log,"   ON    |");
    else
        fprintf(p_log,"   OFF   |");
    
    fprintf(p_log," %2d  |",inp->jumpd);
    
    if (inp->intra_upd==1)
        fprintf(p_log,"   ON    |");
    else
        fprintf(p_log,"   OFF   |");
    
    fprintf(p_log,"%5.3f|",snr->snr_y1);
    fprintf(p_log,"%5.3f|",snr->snr_u1);
    fprintf(p_log,"%5.3f|",snr->snr_v1);
    fprintf(p_log,"%5.3f|",snr->snr_ya);
    fprintf(p_log,"%5.3f|",snr->snr_ua);
    fprintf(p_log,"%5.3f|",snr->snr_va);    
    fprintf(p_log,"%7.0f|",stat->bitr0);
    fprintf(p_log,"%7.0f|\n",stat->bitrate);

    fclose(p_dec);
    fclose(p_out);
    fclose(p_in);
    fclose(p_log);
    fclose(p_stat);
}


void init()
{
    /*  Some matrices are initilized here. */
    
    const int mcp0[9][2]=
    {
        {0,0},{0,-1},{0,1},{-1,0},{1,0},{-1,1},{1,1},{-1,-1},{1,-1}
    };
    int i,j,k,l,i2,l2,ii,ind;
  
    k=1;
    for (l=1; l <= 40; ++l) 
    {
        l2=l+l;
        
        for (i=-l+1; i <= l-1; ++i) 
        {
            for (j=-l; j <= l; j += l2) 
            {
                mcpos[k][0]= i; /* mcpos contains the vector positions organized to perform a spiral search */
                mcpos[k][1]= j;
                ++k;
            }
        }
        
        for (j=-l; j <= l; ++j) 
        {
            for (i=-l;i <= l; i += l2) 
            {
                mcpos[k][0]= i;
                mcpos[k][1]= j;
                ++k;
            }
        }
    }
    
    for (k=0; k <= 8; ++k) 
    {
        for (l=0; l <= 1; ++l) 
        {
            mcpos[k][l]= mcp0[k][l];
        }
    }
    
    /*  mcbit[] is the number of bits used for motion vectors.  
        It is used to add a portion to the SAD depending on bit usage in the motion search
    */
    
    mcbit[0]=1;
    ind=0;
    for (i=0; i <= 8; ++i) 
    {
        ii= 2*i + 3;
        for (j=1; j <= (int)pow(2,i); ++j) 
        {
            ++ind;
            mcbit[ind]=ii;
        }
    }
    
    /*  ltab() is the table used for loop-and post filter. */
    
    for (k=1; k <= 5; ++k) 
    {
        for (i=1; i <= 100; ++i) 
        {
            ii=mmin(k,i);
            ltab[i+300][k]=ii;
            ltab[300-i][k]=-ii;
        }
    }
    
    /*  telenor_quad(0:255) SNR quad array, values above 5000 is set to 5000 */
    
    for (i=0; i <= 255; ++i) 
    {
        i2=mmin(i*i,5000);
        telenor_quad[i]=i2;
    }
} 


