
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  Name :       image.c
*
*  Description: Encodes one frame
*
************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "global.h"
#include "image.h"


void image(struct img_par *img,struct inp_par *inp,struct stat_par *stat)
{
    int multpred;
    int len,info,temp_ref;
    int i2,i,j;
    int uv;

    if (img->pic_no == 0)              /* for first frame, set image type to intra */
    {
        img->pic_type=INTRA_IMG;
        img->quant=abs(inp->quant_0);  /* may have different quant for first and remaining frames */
        if (img->quant>31)             
        {
            printf("Error input parameter quant_0,check configuration file\n");
            exit (0);
        }
    } 
    else                                /* inter frame */
    {
        img->pic_type=INTER_IMG;  
        
        img->quant=abs(inp->quant_n);
        if (img->quant>31)
        {
            printf("Error input parameter quant_n, check configuration file\n");
            exit(0);
        }
        
        if (inp->no_multpred <= 1)
            multpred=FALSE;
        else if(inp->no_multpred <= MAX_MULT_PRED)
            multpred=TRUE;
        else
        {
            printf("Error: input parameter 'no_multpred' exceeds limit, check configuration file \n");
            exit(0);
        }
    }
    
    img->LineMb_intra=img->LineMb_upd;   /*  img->LineMb_intra indicates which GOB to intra code for this frame 
                                            (see use of 'inp->intra_upd')*/ 
    if (inp->intra_upd > 0) 
    {
        img->LineMb_upd=img->pic_no/inp->intra_upd % img->img_width/MB_SIZE;
    }
    
    /*     Bits for picture header and picture type */
    
    len=LEN_STARTCODE;                                /* length of startcode for the bitstream */      
    temp_ref=(img->pic_no*(inp->jumpd+1) % 256 << 7); /* temp_ref tells which image in referance sequence is coded (wrapps at 255) */
    info=temp_ref+(img->quant << 2)+(inp->img_format << 1);
    put(len,info); /* write first header word to stream(temporal referance + img->quant + image format */
    
    stat->bit_ctr += len;                             /* keep bit usage */
    tmp_bit_use[0][img->pic_type] += len;
    
    if (img->pic_type == INTRA_IMG) 
    {
        len=3;
        info=1;
    }
    else if((img->pic_type == INTER_IMG) && (multpred == FALSE)) /* inter single reference frame */
    {
        len=1;
        info=0;
    }
    else if((img->pic_type == INTER_IMG) && (multpred == TRUE)) /* inter multipple reference frames */
    {
        len=3;
        info=0;
    }
       
    put(len,info);                                              /* write picture type to stream */
    
    stat->bit_ctr += len;
    tmp_bit_use[0][img->pic_type] += len;
    
    /* 
        Read one new frame from the original sequence.  
        inp->jumpd reflects frame skipping, mult with pic_type to start with first frame 
    */ 
    
    for (i2=0; i2 <= inp->jumpd*img->pic_type; ++i2) 
    {
        for (j=0; j < img->img_height; ++j) 
        {
            for (i=0; i < img->img_width; ++i) 
            {
                imgY[i][j][0]=fgetc(p_in);          /* write over unused images */
            }
        }
        for (uv=0; uv < 2; ++uv) 
        {
            for (j=0; j < img->img_height_cr ; ++j) 
            {
                for (i=0; i < img->img_width_cr; ++i) 
                {
                    imgUV[i][j][0][uv]=fgetc(p_in);
                }
            }
        }
    }
    /* Loops for coding of all macro blocks in a frame */
    
    for (img->LineMb=0; img->LineMb < img->img_height/MB_SIZE; ++img->LineMb) 
    {
        img->Line4Pix = img->LineMb*4;
        img->LineCPix = img->LineMb*8;
        img->LinePix  = img->LineMb*16;
        
        if (inp->intra_upd > 0 && img->LineMb <= img->LineMb_intra) 
            img->img_height1=(img->LineMb_intra*16)+15;     /* for extra intra MB */
        else
            img->img_height1=img->img_height-1;
        
        if (img->pic_type == INTER_IMG) 
        {
            ++stat->quant0;
            stat->quant1 += img->quant;                     /* to find average quant for inter frames*/
        }
        
        for (img->ColMb=0; img->ColMb < img->img_width/MB_SIZE; ++img->ColMb) 
        {
            img->ColC4Pix = img->ColMb*2;
            img->Col4Pix  = img->ColMb*4;
            img->ColCPix  = img->ColMb*8;
            img->ColPix   = img->ColMb*16;

            macroblock(img,inp,stat);   
        }
    }
}


void loopfilter(struct img_par *img)
{
    int i,j;
    int id,uv;
    
    /*  Luma horizontal */
    
    for (j=0; j < img->img_height; ++j) 
    {
        for (i=3; i < img->img_width-1 ; i += 4) 
        {
            id=(imgY[i-1][j][1]-imgY[i+2][j][1]-((imgY[i][j][1]-imgY[i+1][j][1])*4))/8;
            id=ltab[id+300][ISTR[img->quant][1]];

            /*## force the value to be within [0,255] ##*/ 
            imgY[i][j][1]= mmax(0,mmin(imgY[i][j][1]+id,255));
            imgY[i+1][j][1]= mmax(0,mmin(imgY[i+1][j][1]-id,255));
        }
    }
    
    /*  Luma vertical */
    
    for (i=0; i < img->img_width; ++i) 
    {
        for (j=3; j < img->img_height-1; j += 4) 
        {
            id=(imgY[i][j-1][1]-imgY[i][j+2][1]-((imgY[i][j][1]-imgY[i][j+1][1])*4))/8;
            id=ltab[id+300][ISTR[img->quant][1]];
            imgY[i][j][1]= mmax(0,mmin(imgY[i][j][1]+id,255));
            imgY[i][j+1][1]= mmax(0,mmin(imgY[i][j+1][1]-id,255));
        }
    }
    
    /*  Chroma horizontal */
    
    for (uv=0; uv <= 1; ++uv) 
    {
        for (j=0; j < img->img_height_cr; ++j) 
        {
            for (i=3; i < img->img_width_cr-1; i += 4) 
            {
                id=(imgUV[i-1][j][1][uv]-imgUV[i+2][j][1][uv]-((imgUV[i][j][1][uv]-imgUV[i+1][j][1][uv])*4))/8;
                id=ltab[id+300][ISTR[img->quant][1]];
                imgUV[i][j][1][uv]= mmax(0,mmin(imgUV[i][j][1][uv]+id,255));
                imgUV[i+1][j][1][uv]= mmax(0,mmin(imgUV[i+1][j][1][uv]-id,255));
            }
        }
        
        /*  Chroma vertical */
        
        for (i=0; i < img->img_width_cr; ++i) 
        {
            for (j=3; j < img->img_height_cr-1; j += 4) 
            {
                id=(imgUV[i][j-1][1][uv]-imgUV[i][j+2][1][uv]-((imgUV[i][j][1][uv]-imgUV[i][j+1][1][uv])*4))/8;
                id=ltab[id+300][ISTR[img->quant][1]];
                imgUV[i][j][1][uv]= mmax(0,mmin(imgUV[i][j][1][uv]+id,255));
                imgUV[i][j+1][1][uv]= mmax(0,mmin(imgUV[i][j+1][1][uv]-id,255));
            }
        }
    }
}

/*## <Sharp Start> ##*/

/*## the onethirdpix() is replaced by halfpix() to do 1/2 pixel upsampling ##*/

void halfpix(struct img_par *img,struct inp_par *inp)
{
    int jn[2];
    int in[2];
    int i,j;
    int i2,j2,ii,jj,iii,jjj;
    int i1,j1;
    int is,uv;
    int m1,m2,m3,m4;
    
    /*## Luma : 1/2 pixel bilinear interpolation ##*/

    for (i=0; i <= img->img_width-1; ++i) 
    {
        in[0]=i;
        in[1]=mmin(img->img_width-1,i+1);
        i2=i*2;
        for (j=0; j < img->img_height; ++j) 
        {
            jn[0]=j;
            jn[1]=mmin(img->img_height-1,j+1);
            j2=j*2;

            m1 = imgY[in[0]][jn[0]][1];
            m2 = imgY[in[1]][jn[0]][1];
            m3 = imgY[in[0]][jn[1]][1];
            m4 = imgY[in[1]][jn[1]][1];

            mref[i2][j2][img->np0] = m1;
            mref[i2+1][j2][img->np0] = (m1+m2+1)/2;
            mref[i2][j2+1][img->np0] = (m1+m3+1)/2;
            mref[i2+1][j2+1][img->np0] = (m1+m2+m3+m4+2)/4;
        }
    }
    
    /*## 
      Chroma : simply a copy of the reconstruced image. 
      No 1/2 pixel upsampling of chroma image is needed, since it's not used in 
      motion estimation. When doing motion compensation, chroma value will be 
      interpolated on the line. 
    ##*/

    for (uv=0; uv <= 1; ++uv)
    {
        for (i=0; i < img->img_width_cr; ++i)
        {
            for (j=0; j < img->img_height_cr; ++j)
            {
                mcef[i][j][uv][img->np0] = imgUV[i][j][1][uv];
            }
        }
    }
}

/*## <Sharp End> ##*/

void postfilter(struct img_par *img)
{  
    int i_1,i_2,j_1,j_2,uv;
    int i,j,ip1,ip2,jp1,jp2;
    int it,is;
 
    /* postfiler horisontal luma */
    for(i=0;i<img->img_width;i++)
	{
		i_2=mmax(0,i-2);
		i_1=mmax(0,i-1);
		ip2=mmin(img->img_width-1,i+2);
		ip1=mmin(img->img_width-1,i+1);
		it=ISTR[img->quant][((i+3)&2)/2];
		
        for(j=0;j<img->img_height;j++)                              /* avoid two pels on edge */
        {
            is = (imgY[i_2][j][1]+imgY[ip2][j][1]+2*(imgY[i_1][j][1]+imgY[ip1][j][1])-6*imgY[i][j][1])/8;
            imgY[i][j][2]=imgY[i][j][1]+ltab[is+300][it];           /* temp array             */
        }
	} 

   for(j=0;j<img->img_height;j++)
   {
        j_2=mmax(0,j-2);
		j_1=mmax(0,j-1);
        jp2=mmin(img->img_height-1,j+2);
        jp1=mmin(img->img_height-1,j+1);
        it=ISTR[img->quant][((j+3)&2)/2];
        for(i=0;i<img->img_width;i++)
        {
            is = (imgY[i][j_2][2]+imgY[i][jp2][2]+2*(imgY[i][j_1][2]+imgY[i][jp1][2])-6*imgY[i][j][2])/8;
            imgY[i][j][1] = imgY[i][j][2]+ltab[is+300][it];
        }
   }
       
   /* horisontal chroma */
   for (uv=0;uv<2;uv++)
   {
       for(i=0;i<img->img_width_cr;i++)
       {
           i_2=mmax(0,i-2);
           i_1=mmax(0,i-1);
           ip2=mmin(img->img_width_cr-1,i+2);
           ip1=mmin(img->img_width_cr-1,i+1);
           it=ISTR[img->quant][((i+3)&2)/2];
           for(j=0;j<img->img_height_cr;j++) /* avoid two first and last lines */
           {
               is = (imgUV[i_2][j][1][uv]+imgUV[ip2][j][1][uv]+2*(imgUV[i_1][j][1][uv]+imgUV[ip1][j][1][uv])-6*imgUV[i][j][1][uv])/8;
               imgUV[i][j][2][uv] = imgUV[i][j][1][uv]+ltab[is+300][it];  /* temp array */
           }
       /* postfiler vertical chroma */
       } 
       for(j=0;j<img->img_height_cr;j++)
       {
           j_2=mmax(0,j-2);
           j_1=mmax(0,j-1);
           jp2=mmin(img->img_height_cr-1,j+2);
           jp1=mmin(img->img_height_cr-1,j+1);
           it=ISTR[img->quant][((j+3)&2)/2];
           for(i=0;i<img->img_width_cr;i++) /* avoid two first and last lines */
           {
               is = (imgUV[i][j_2][2][uv]+imgUV[i][jp2][2][uv]+2*(imgUV[i][j_1][2][uv]+imgUV[i][jp1][2][uv])-6*imgUV[i][j][2][uv])/8;
               imgUV[i][j][1][uv] = imgUV[i][j][2][uv]+ltab[is+300][it];
           }
       }
   }
}

void find_snr(struct snr_par *snr,struct img_par *img)
{
    int i,j;
    int diff_y,diff_u,diff_v;
    
    /*  Calculate  PSNR for Y, U and V. */
    
    /*     Luma. */
    
    diff_y=0;
    for (i=0; i < img->img_width; ++i) 
    {
        for (j=0; j < img->img_height; ++j) 
        {
            diff_y += telenor_quad[abs(imgY[i][j][0]-imgY[i][j][1])];
        }
    }
    
    /*     Chroma. */
    
    diff_u=0;
    diff_v=0;
    
    for (i=0; i < img->img_width_cr; ++i) 
    {
        for (j=0; j < img->img_height_cr; ++j) 
        {
            diff_u += telenor_quad[abs(imgUV[i][j][0][0]-imgUV[i][j][1][0])];
            diff_v += telenor_quad[abs(imgUV[i][j][0][1]-imgUV[i][j][1][1])];
        }
    }
    
    /*  Collecting SNR statistics */
    if (diff_y != 0)
    {   
        snr->snr_y=(float)(10*log10(65025*(float)img->impix/(float)diff_y));        /* luma snr for current frame */
        snr->snr_u=(float)(10*log10(65025*(float)img->impix/(float)(4*diff_u)));    /* u croma snr for current frame, 1/4 of luma samples*/
        snr->snr_v=(float)(10*log10(65025*(float)img->impix/(float)(4*diff_v)));    /* v croma snr for current frame, 1/4 of luma samples*/
    }
    
    if (img->pic_no == 0) 
    {
        snr->snr_y1=(float)(10*log10(65025*(float)img->impix/(float)diff_y));       /* keep luma snr for first frame */ 
        snr->snr_u1=(float)(10*log10(65025*(float)img->impix/(float)(4*diff_u)));   /* keep croma u snr for first frame */
        snr->snr_v1=(float)(10*log10(65025*(float)img->impix/(float)(4*diff_v)));   /* keep croma v snr for first frame */ 
        snr->snr_ya=snr->snr_y1;
        snr->snr_ua=snr->snr_u1;
        snr->snr_va=snr->snr_v1;
    } 
    else 
    {
        snr->snr_ya=(float)(snr->snr_ya*(img->pic_no)+snr->snr_y)/(img->pic_no+1);      /* average snr lume for all frames inc. first */
        snr->snr_ua=(float)(snr->snr_ua*(img->pic_no)+snr->snr_u)/(img->pic_no+1);      /* average snr u croma for all frames inc. first  */
        snr->snr_va=(float)(snr->snr_va*(img->pic_no)+snr->snr_v)/(img->pic_no+1);      /* average snr v croma for all frames inc. first  */    
    }
} 



