
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  global.h for H.26L encoder. 
*
*  Copyright (C) 1999  Telenor Satellite Services,Norway
*  Copyright (C) 1999  Tandberg Telecom A.S.,Norway
*  
*  Contacts: 
*  Inge Lille-Langy               <Inge.Lille-Langoy@international.telenor.no>
*
*  Telenor Satellite Services 
*  Keysers gt.13                       tel.:   +47 23 13 86 98
*  N-0130 Oslo,Norway                  fax.:   +47 22 77 79 80
*
*  Tom-Ivar Johansen               <tij@tandberg.no>
*
*  Tandberg Telecom A.S.                tel.:   +47 67 117 743
*  Philip Pedersens v. 22                       +47 67 125 125
*  N-1374 Lysaker,Norway                fax.:   +47 67 125 234
*
************************************************************************/


#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <stdio.h>

/*## <Sharp Start> ##*/

/*## self-defined macros ##*/
#define mmax(a, b)        ((a) > (b) ? (a) : (b))
#define mmin(a, b)        ((a) < (b) ? (a) : (b))
#define mround(x,q)       ((x)/q)

/*## motion accuracy modes ##*/
#define INTEGER         0
#define HALF            1
#define ONE_THIRD       2
#define ONE_SIXTH       3

/*## <Sharp End> ##*/

typedef unsigned char byte;
#define FALSE           0
#define TRUE            1
#define MAX_VALUE       999999 

 /* Picture types  */       
#define INTRA_IMG       0         
#define INTER_IMG       1
    
/* inter MB modes */
#define COPY_MB         0        /* just copy last MB, no motion vectors */  
#define M16x16_MB       1        /* 16 x 16 block */   
#define M16x8_MB        2   
#define M8x16_MB        3
#define M8x8_MB         4
#define M8x4_MB         5   
#define M4x8_MB         6
#define M4x4_MB         7
#define INTRA_MB        9        /* intra prediction mode */

/* intra prediction modes */
#define DC_PRED         0
#define VERT_PRED       1
#define HOR_PRED        2
#define DIAG_PRED_LR    3
#define DIAG_PRED_RL    4        

/* image formats*/
#define QCIF            0
#define CIF             1

#define MB_SIZE         16
#define INIT_FRAME_RATE 30
#define LEN_STARTCODE   31              /* length of start code */
#define MAX_MULT_PRED    5              /* max number of frames to make inter prediction from */


int iMv[88][72][3];                     /* Motion Vectors */
byte imgY[352][288][3];                 /* Luma images */
byte imgUV[176][144][3][2];             /* Chroma images  */

/*## <Sharp Start> ##*/

byte mref[704][576][MAX_MULT_PRED];     /*## 1/2 pix luma ##*/
byte mcef[176][144][2][MAX_MULT_PRED];  /*## 1 pix chroma ##*/

byte mref_mb[16][16][4];                /*## compensated luma for different 
                                             motion accuracy 
                                        ##*/

int total_blocks;                       /*## variables for counting average searching  ##*/
int total_search_position;              /*## positions ##*/

/*## <Sharp End> ##*/


int  mcpos[6561][2];                    /* To obtain spiral search */
int  ihv[4][4][5][9][4][2];  

int predmode[89][73];                   /* prediction mode for inter frames */
int mpr[8][8];
int m7[8][8];
int kof[4][6][18][2][2];  
int kofu[5][2][2];         
int telenor_quad[256];                  /* Array containing square values,used for snr computation  */
                                        /* Values are limited to 5000 for pixel differences over 70 (sqr(5000)). */
int mcbit[512];  
int ltab[602][6]; 
int tmp_bit_use[12][2];                 /* statistics of bit usage */  
int vectmode_use[2][10]                 /* Predmode usage for Inter and Intra frames,
                                           notice that in intra images all MB are coded as intra*/;
int mprr[4][4][5];

struct snr_par         
{
    float snr_y;                 /* current Y SNR*/      
    float snr_u;                 /* current U SNR*/
    float snr_v;                  /* current V SNR*/
    float snr_y1;                /* SNR Y(dB) first frame*/
    float snr_u1;                /* SNR U(dB) first frame*/
    float snr_v1;                /* SNR V(dB) first frame*/
    float snr_ya;                /* Average SNR Y(dB) remaining frames*/
    float snr_ua;                /* Average SNR U(dB) remaining frames*/
    float snr_va;                /* Average SNR V(dB) remaining frames*/
};
struct inp_par
{
   int no_frames;                /* number of frames to be encoded*/
   int quant_0;                  /* QP of first frame*/
   int quant_n;                  /* QP of remaining frames*/
   int jumpd;                    /* number of frames to skip in input sequence (e.g 2 takes frame 0,3,6,9...)*/ 
   int hadamard;                 /* 0: 'normal' SAD in 1/3 pixel search.  1: use 4x4 Haphazard transform and '*/
                                 /* Sum of absolute transform difference' in 1/3 pixel search*/
   int mcrange;                  /* search range - integer pel search and 16x16 blocks.  The search window is 
                                 /* generally around the predicted vector. Max vector is 2xmcrange.  For 8x8 
                                 /* and 4x4 block sizes the search range is 1/2 of that for 16x16 blocks.*/
   int no_multpred;              /* 1: prediction from the last frame only. 2: prediction from the last or 
                                 /* second last frame etc.  Maximum 5 frames */
   int postfilter;               /* 0: No postfilter.  1: use postfilter.*/
   int img_format;               /* 0: QCIF 1: CIF */
   int intra_upd;                /* For error robustness. 0: no special action. 1: One GOB/frame is intra coded     
                                 /* as regular 'update'. 2: One GOB every 2 frames is intra coded etc.  
                                 /* In connection with this intra update, restrictions is put on motion vectors 
                                 /* to prevent errors to propagate from the past*/
   int write_dec;                /* write decoded image to file, for debugging*/
   int bck_tmp;
   char infile[100];             /* YUV 4:2:0 input format*/      
   char outfile[100];            /* H.26L compressed output bitstream*/
 };

struct img_par
{   
    int pic_type;
    int pic_no;                  /* current image number to be encoded*/
    int multframe_no;
    int np0;
    int framerate;
    int mb_hor;                  /* Number of x-MB  (QCIF=11,CIF=22)*/
    int mb_vert;                 /* Number of y-MB  (QCIF= 9,CIF=18)*/
    int mb_vert_cr;
    int img_width;               /* Number of x-samples  (QCIF=176,CIF=352)*/
    int img_width_cr;
    int img_height;              /* Number of y-samples  (QCIF=144,CIF=288)*/
    int img_height_cr;
    int impix;                   /* no of pix in a frame (iMbImageWidth * iMbImageHeight * 256)*/
    int img_height1;             /* For y vector limitation for error robustness*/
    int quant;                   /* quant for the current frame */   
    int LineMb;
    int LineMb_upd;
    int LineMb_intra;
    int mb_mode;                 /* MB mode relevant for inter images, for intra images are all MB intra*/
    int LinePix;
    int LineCPix;
    int Line4Pix;
    int ColMb;
    int Col4Pix;
    int ColC4Pix;
    int ColCPix;
    int ColPix;
    int izh;
    int izv;
    int mhv[8][2];               /* array for different block sizes */

    /*## <Sharp Start> ##*/

    int mb_accuracy;             /*## indicate the motion vector accuracy in the MB  ##*/
    int accuracy_count[4];       /*## count usage frequency of three motion accuracy ##*/

    /*## <Sharp End> ##*/

};

struct stat_par         /* statistics */
{
    int   quant0;       /* quant for the first frame */
    int   quant1;       /* average quant for the remaining frames */           
    float bitr;         /* bit rate for current frame, used only for output til terminal*/ 
    float bitr0;        /* stored bit rate for the first frame*/
    float bitrate;      /* average bit rate for the sequence except first frame*/ 
    int   bit_ctr;      /* counter for bit usage */ 
    int   bit_ctr_0;    /* stored bit use for the first frame*/
    int   bit_ctr_n;    /* bit usage for the current frame*/
};

/* prototypes */
void put(int len,int info);
void macroblock(struct img_par *img,struct inp_par *inp,struct stat_par *stat);
void intrapred(int CurrPixX,int CurrPixY);
void init();
void find_snr(struct snr_par *snr,struct img_par *img);
void postfilter(struct img_par *img);
void loopfilter(struct img_par *img);
void halfpix(struct img_par *img,struct inp_par *inp);
void image(struct img_par *img,struct inp_par *inp,struct stat_par *stat);
void find_sad(int *is,int hadamard);
void dct_luma(int pos_mb1,int pos_mb2,int *nonzero,int *sngl_nonzero,struct img_par *img);
void dct_chroma(int uv,int *i11,struct img_par *img);
int  motion_search(struct inp_par *inp,struct img_par *img, int isi);
void n_linfo(int n,int *len,int *info);
void mvd_linfo(int mvd,int *len,int *info);
void levrun_linfo_c2x2(int level,int run,int *len,int *info);
void levrun_linfo_intra(int level,int run,int *len,int *info);
void levrun_linfo_inter(int level,int run,int *len,int *info);

/* files */
FILE *p_dec;        /* internal decoded image for debugging*/
FILE *p_out;        /* H.26L output bitstream */ 
FILE *p_stat;       /* status file for the last encoding session */
FILE *p_log;        /* SNR file */  
FILE *p_in;         /* YUV */

#endif
