
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/


/************************************************************************
*
*  block.h for H.26L encoder. 
*  
************************************************************************/
#ifndef _BLOCK_H_
#define _BLOCK_H_

#include <stdio.h>
#include "global.h"


const int JQQ1=1048576;
const int JQQ2= 524288;
const int JQQ3= 349525;
/*const int JQQ4= 262144;*/
const int JQQ4= 175000;

const int JQ[32][3] =
{
    {620,  3881,  1 }, 
    {553,  4351,  1 },  
    {492,  4890,  1 },   
    {439,  5481,  1 },  
    {391,  6154,  1 },   
    {348,  6914,  1 },   
    {310,  7761,  2 },  
    {276,  8718,  2 },  
    {246,  9781,  2 },  
    {219,  10987, 2 },    
    {195,  12339, 3 },  
    {174,  13828, 3 },   
    {155,  15523, 3 },   
    {138,  17435, 4 },  
    {123,  19561, 4 },    
    {110,  21873, 5 },   
    { 98,  24552, 5 },
    { 87,  27656, 6 },  
    { 78,  30847, 7 }, 
    { 69,  34870, 7 },
    { 62,  38807, 8 },
    { 55,  43747,  9}, 
    { 49,  49103, 11},
    { 44,  54683, 12},
    { 39,  61694, 13},
    { 35,  68745, 15},
    { 31,  77615, 17},
    { 27,  89113, 19}, 
    { 24,  100253,21}, 
    { 22,  109366,24},  
    { 19,  126635,27}, 
    { 17,  141533,30},
};
const byte NSCAN1[16][2] =   /* single scan */
{
    {0,0},{1,0},{0,1},{0,2},{1,1},{2,0},{3,0},{2,1},{1,2},{0,3},{1,3},{2,2},{3,1},{3,2},{2,3},{3,3}
};
const byte NSCAN2[8][2][2] = /* double scan */
{
    {{0,0},{0,1}},
    {{1,0},{0,2}},
    {{2,1},{0,1}},
    {{2,1},{1,2}},
    {{2,0},{2,3}},
    {{3,1},{0,3}},
    {{3,2},{1,3}},
    {{3,3},{2,3}},
};

/*## <Sharp Start> ##*/

/*## 1/3 sub-pixel motion search patterns ##*/

const int pattern0[8][4][2]={
  {{0,0},{-1,-1},{0,-1},{1,-1}},
  {{0,0},{-1,1},{0,1},{1,1}},
  {{0,0},{-1,-1},{-1,0},{-1,1}},
  {{0,0},{1,-1},{1,0},{1,1}},
  {{0,0},{-1,0},{-1,1},{0,1}},
  {{0,0},{1,0},{1,1},{0,1}},
  {{0,0},{-1,0},{-1,-1},{0,-1}},
  {{0,0},{0,-1},{1,-1},{1,0}}
};

const int pattern1[8][4][2]={
  {{0,-1},{0,-2},{-1,-2},{-1,-1}},
  {{0,-1},{0,-2},{1,-2},{1,-1}},
  {{0,1},{0,2},{-1,2},{-1,1}},
  {{0,1},{0,2},{1,2},{1,1}},
  {{-1,0},{-2,0},{-2,-1},{-1,-1}},
  {{-1,0},{-2,0},{-2,1},{-1,1}},
  {{1,0},{2,0},{2,-1},{1,-1}},
  {{1,0},{2,0},{2,1},{1,1}}
};

const int pattern2[4][4][2]={
  {{-1,1},{-2,1},{-2,2},{-1,2}},
  {{1,1},{2,1},{2,2},{1,2}},
  {{-1,-1},{-2,-1},{-2,-2},{-1,-2}},
  {{1,-1},{2,-1},{2,-2},{1,-2}}
};

const int neighbor[4][2]={{7,8},{5,6},{7,5},{8,6}};

/*## 1/6 pixel cubic interpolator filters ##*/

const float LF0[4][6]=
{
    0,  -0.0579,  -0.0741,  -0.0625,  -0.0370,  -0.0116,
1.0000,   0.9375,   0.7778,   0.5625,   0.3333,   0.1319,
    0,   0.1319,   0.3333,   0.5625,   0.7778,   0.9375,
    0,  -0.0116,  -0.0370,  -0.0625,  -0.0741,  -0.0579
};

/*## a short table for counting MB mode bits ##*/ 

int ModeBits[9]={1,3,3,5,5,5,5,7,7};

/*## motion accuracy conversion table ##*/
/*## integer :  6
     1/2     :  3
     1/3     :  2
     1/6     :  1
##*/

int Accuracy[4]={6,3,2,1};

/*## <Sharp End> ##*/

#endif
