/************************************************************************
 *
 *  write_bmp.c for H.26L decoder. 
 *  Copyright (C) 1999  Telenor Satellite Services, Norway
 *  
 *  Contacts: 
 *  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
 * 
 *
 *  Telenor Satellite Services 
 *  Keysers gt.13                        tel.:   +47 23 13 86 98
 *  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
 *  
 ************************************************************************/
/* This routine is just for debugging, may be removed */
	
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"

#define HEADERLEN			54				/* for 24 bit color*/
 
static byte cifheader[HEADERLEN]=		/* standard header for 352 x 288 x 24bit CIF size */
{
	0x42,0x4D,0x36,0xA4,0x04,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0x60,0x01,0x00,0x00,0x20,0x01,0x00,0x00,0x01,0x00,0x18,0x00,0x00,0x00,
	0x00,0x00,0x00,0xA4,0x04,0x00,0x12,0x0B,0x00,0x00,0x12,0x0B,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00
};
static byte qcifheader[HEADERLEN]=		/* standard header for 176 x 144 x 24bit QCIF size*/
{
	0x42,0x4D,0x36,0x29,0x01,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0xB0,0x00,0x00,0x00,0x90,0x00,0x00,0x00,0x01,0x00,0x18,0x00,0x00,0x00,
	0x00,0x00,0x00,0x29,0x01,0x00,0x12,0x0B,0x00,0x00,0x12,0x0B,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00
};

void write_bmp(struct img_par *img,int postfilter)
{
	FILE *p_outfile;	
    
	int lines,pels;
	float r,g,b;
	
	float U,V;	
    byte Y;
	byte Cr,Cb;
	int i,j;
	int filterindex;
  
	char ch_no[2];
	char outfilename[12]="Framexx.bmp";						    /* output filnames, make room for index*/
  
    sprintf(ch_no,"%d",img->pic_no);

    /*	itoa(img->pic_no,ch_no,10);*/									 
    if (img->pic_no<10)                                         /* insert index */
    {
        outfilename[5]='0';
        outfilename[6]=ch_no[0];
    }  
    else
    {    
        outfilename[5]=ch_no[0];							
        outfilename[6]=ch_no[1];
    }   
	p_outfile = fopen(outfilename,"wb");	

	if (img->icif == QCIF)
    {
        lines = LINES_QCIF;                                   
        pels = PELS_QCIF;
        for (i=0;i<HEADERLEN;i++)				                /* add hardcoded bmp header for 176x144x24(QCIF) */
		    fputc(qcifheader[i],p_outfile);
    }
    else /* CIF */
    {
        lines = LINES_CIF;                                    
        pels = PELS_CIF;
        for (i=0;i<HEADERLEN;i++)				                /*add hardcoded bmp header for 352x288x24(CIF) */
		    fputc(cifheader[i],p_outfile);
    }	
   
    if(postfilter)
       filterindex=0;
    else
       filterindex=1;				
	
	for(i=lines-1;i>=0;i--)					                    /* first pixel for bitmap down left */
		for(j=0;j<pels;j++)
		{
			Cr=imgUV[j/2][i/2][filterindex][0];
			Cb=imgUV[j/2][i/2][filterindex][1];			
			
			Y=imgY[j][i][filterindex];

			U=((float)Cr-(float)128);
			V=((float)Cb-(float)128);
			
			b = Y + U;                                          /* convert from yuv to bmp */
			r = Y + V;
			g = Y-(float)0.51*V-(float)0.187*U; 
			
			if(r>255)									
				r=255;
			else if(r<0)
				r=0;
			if(g>255)
				g=255;
			else if(g<0)
				g=0;			
			if(b>255)
				b=255;
			else if(b<0)
				b=0;
			
			fputc((byte)b,p_outfile);
			fputc((byte)g,p_outfile);
			fputc((byte)r,p_outfile);	
		}	
}
