
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
 *
 *  stream.c for H.26L decoder, reads MSB in stream first. 
 *  Copyright (C) 1999  Telenor Satellite Services, Norway
 *  
 *  Contacts: 
 *  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
 * 
 *
 *  Telenor Satellite Services 
 *  Keysers gt.13                        tel.:   +47 23 13 86 98
 *  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
 *  
 ************************************************************************/

/* #include <fstream.h> */
#include <stdio.h>
#include <stdlib.h>

#include "global.h"
#include "stream.h"

void fillbuf(byte buf[],FILE *p_in) 
{  
    int i=0;
    byte ch;

    ch = fgetc( p_in );
    for (i=0;i<MAX_FILE_SIZE && (feof(p_in)==0); i++) /* read the hole stream before any decoding starts */
    {
        buf[i]=ch;
        ch = fgetc( p_in );
    }
    filelength=i;                                      /* find filelength for use if no end of file code is found */   
}

void write_frame(int icif,int postfilter,FILE *p_out) 
{  
    int i,j;
	int lines,pels;
    int filterindex;
 
	if (icif == QCIF)
    {
        lines = LINES_QCIF;                                      
        pels = PELS_QCIF;
    }
    else   /* CIF */
    {
        lines = LINES_CIF;                                   
        pels = PELS_CIF;
    }
    if(postfilter)
       filterindex=0;
    else
       filterindex=1;				

    for(i=0;i<lines;i++)
        for(j=0;j<pels;j++)
            fputc(imgY[j][i][filterindex],p_out);

    for(i=0;i<lines/2;i++)
        for(j=0;j<pels/2;j++)    
            fputc(imgUV[j][i][filterindex][0],p_out);
  
    for(i=0;i<lines/2;i++)
        for(j=0;j<pels/2;j++)    
            fputc(imgUV[j][i][filterindex][1],p_out);
        
}

int findinfo(byte *buffer,int totbitoffset,int *info)   
{   
    int byteoffset;                                                 /* byte from start of frame */
    int bitoffset;                                                  /* bit from start of byte */                                                 
    int ctr_bit;
    int bitcounter=1;                                              
   
    byteoffset= totbitoffset/8;                                    
    bitoffset= 7-(totbitoffset%8);                                  /* Find bit offset in current byte, start with MSB  */
   
    ctr_bit = (buffer[byteoffset] & (0x01<<bitoffset));
    
    *info=0;                                                        /* shortest possible code is 1, then info is always 0 */
    
    while(ctr_bit==0)
    {   
        bitoffset-=2;
        
        if (bitoffset<0)    
        {
            bitoffset=bitoffset+8;                                  /* check next byte */
            byteoffset++;       
        }
		if (byteoffset == GetFileLength())                          /* This inserts an "artifical" sequence end code when end of stream */
        {
			*info = 1;                                              /* signal end of sequence */
			return 31;
		}        
        ctr_bit=buffer[byteoffset] & (0x01<<(bitoffset));
        if(bitoffset>=7)                                
        {
            if (buffer[byteoffset-1] & (0x01))                      /* go back to last bit of last byte */                                                               
                *info = ((*info << 1) | 0x01);                      /* multiply with 2 and add 1       */        
            else
                *info = (*info << 1);                               /* multiply with 2    */
        }
        else
        {
            if (buffer[byteoffset] & (0x01<<(bitoffset+1)))         /* make infoword   */
                *info = ((*info << 1) | 0x01);                     
            else
                *info = (*info << 1);                              
        }        
        bitcounter+=2;          
    }                                                               /* lenght of codeword and info is found  */
    return bitcounter;                                              /* return absolute offset in bit from start of frame */
}

/*## <Sharp Start> ##*/

/*## the read_bitstream is simplifed to fill the buffer.
     it's major bits reading function is moved to function
     get_len_info() 
##*/

int read_bitstream(FILE *p_in)                      
{
    fillbuf(buf,p_in);      /* copy the file to buffer */ 
}

int get_len_info(int *len, int *info)
{
    (*len) =  findinfo(buf,bitoffset,info); 

    if ((*len) >= LEN_PSC ) 
    {
        if(word_counter>1)        /* added the ability to handle           */
        {                         /* byte aligned start code. KOL 03/15/99 */
           return word_counter;
        }
        else if ((*info)&1)       /* eos */
        {
           end_of_sequence = 1;
	   return 0;			
        }
    }
    bitoffset+=(*len);
    word_counter++;

    return 1 ;
}

/*## special process for motion accuracy 2-1-2 VLC code ##*/

int get_212vlc_len_info(int *len, int *info)
{
    (*len) =  find_212vlc_info(buf,bitoffset,info);

    bitoffset+=(*len);
    word_counter++;

    return 1 ;
}

int find_212vlc_info(byte *buffer,int totbitoffset,int *info)   
{
    int byteoffset;                   /* byte from start of frame */
    int bitoffset;                    /* bit from start of byte */                                                 
    int ctr_bit;
    int bitcounter=1;                                              
   
    byteoffset= totbitoffset/8;                                    
    bitoffset= 7-(totbitoffset%8);    /* Find bit offset in current byte, 
                                         start with MSB  */
   
    ctr_bit = (buffer[byteoffset] & (0x01<<bitoffset));
    
    *info=0;                          /* shortest possible code is 1, 
                                         then info is always 0 */
    if(ctr_bit==0)
    {   
        bitoffset-=1;
        
        if (bitoffset<0)    
        {
            bitoffset=bitoffset+8;    /* check next byte */
            byteoffset++;       
        }

        ctr_bit=buffer[byteoffset] & (0x01<<(bitoffset));

        if(ctr_bit==0)
          *info = 0;
        else
          *info = 1;

        bitcounter++;          
    }   

    return bitcounter;
}

void reset_word_counter()
{
   word_counter=1;
}

/*## <Sharp End> ##*/
