
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  macroblock.c for H.26L decoder. 
*  Copyright (C) 1999  Telenor Satellite Services, Norway
*  
*  Contacts: 
*  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
* 
*
*  Telenor Satellite Services 
*  Keysers gt.13                        tel.:   +47 23 13 86 98
*  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
*  
************************************************************************/

#include <stdio.h>
#include <math.h>                   
#include <stdlib.h>

#include "global.h"
#include "macroblock.h"

int macroblock(struct img_par *img)
{
    int js[2][2];
    int kofu[4];    
    int lhv[92][72][3];    
    int jg2,jg4,jg8,jg16,jg32,m2,m4,m8,m16,m32;  
    int mode,i,j,ii,jj,iii,jjj,n,i1,j1,ie,j4,i4,k,i0,i2,j2,ip,ip0,ip1,ip2,j0;    
    int kk,iv,icbp,uv,ll,js0,js1,js2,js3,jf,if1,lh,lv;
    int ke,kee,kkk;
    int level,irun;
    int nref;
    int len,info;
    int ka;
      
    jg2=img->jgob*2;
    jg4=img->jgob*4;
    jg8=img->jgob*8;
    jg16=img->jgob*16;
    jg32=img->jgob*32;
    
    m2=img->igob*2;
    m4=img->igob*4;
    m8=img->igob*8;
    m16=img->igob*16;
    m32=img->igob*32;
    
    if (img->pic_type==INTER_IMG_1 || (img->pic_type==INTER_IMG_MULT))         /* inter frame */
    {   
        /*## <Sharp Start> ##*/
 
        get_len_info(&len,&info);
 
        mode = (int)pow(2,(len/2))+info-1;                                              
        /*## get the motion accuracy value using 2-1-2 VLC table ##*/

        if(mode != COPY_MB && mode != INTRA_MB)
        {
           int acc;

           get_212vlc_len_info(&len,&info);

           acc = (int)pow(2,(len/2))+info-1;                                              
           if(acc == 0)
           {
              img->mb_accuracy=ONE_THIRD;
           }
           else if(acc == 1)
           {
              img->mb_accuracy=HALF;
           }
           else if(acc == 2)
           {
              img->mb_accuracy=ONE_SIXTH;
           }
           else
           {
              printf("Wrong motion accuracy, exiting\n");
              return SEARCH_SYNC;
           }
        }

        /*## <Sharp End> ##*/

    }
    else if ((img->pic_type==INTRA_IMG))          /* for intra image, MB mode always INTRA_MB */
    {
        mode=INTRA_MB;
    }
    else
    {
        printf("Wrong ipmode, exiting\n");
        return SEARCH_SYNC;
    }
    if (img->jgob==0 && img->igob==0)        
    {
        for(i=0;i<88;i++)                   /* set edge to -1, indicate nothing to predict from */
            img->jpred[i+1][0]=-1;
        for(j=0;j<72;j++)
            img->jpred[0][j+1]=-1; 
    }
    
    lhv[m4+4][jg4][2]=img->pic_no;

    for (i=0;i<BLOCK_SIZE;i++)              /* zero vectors and pred. modes  */
        for(j=0;j<BLOCK_SIZE;j++)           
        {
            lhv[m4+i+4][jg4+j][0] = 0;
            lhv[m4+i+4][jg4+j][1] = 0;
            img->jpred[m4+i+1][jg4+j+1] = 0;
        }
    nref=img->np0;
    ka=1;
    
    if (mode==COPY_MB)                  /* just keep last macroblock, no further action */
        return DECODING_OK;                 
    
    if (mode==INTRA_MB)                 /* read and store prediction for INTRA_MB blocks */
    {
        for(i=0;i<MB_BLOCK_SIZE/2;i++)  /* find prediction */ 
        {
            ii=2*(i&0x01);
            jj=i/2;
            
            /*## <Sharp Start> ##*/
 
            get_len_info(&len,&info);
 
            /*## <Sharp End> ##*/
 
            n= (int) pow(2,(len/2))+info-1;

            if (n>24)                
            {              
                return SEARCH_SYNC;
            } 

            i1=m4+ii;
            j1=jg4+jj;
            
            img->jpred[i1+1][j1+1] = IPRANG[MODN[n][0]][img->jpred[i1+1][j1]+1][img->jpred[i1][j1+1]+1];
            
            img->jpred[i1+2][j1+1] = IPRANG[MODN[n][1]][img->jpred[i1+2][j1]+1][img->jpred[i1+1][j1+1]+1];
        }
    }
    else                                      /* inter frame, read vector data */
    {     
        if(img->pic_type==INTER_IMG_MULT)     /* read frame number to copy blocks from */
        {
            /*## <Sharp Start> ##*/
 
            get_len_info(&len,&info);
 
            /*## <Sharp End> ##*/
 
            ka=(int)pow(2,len/2)+info;
            nref=(img->np0+6-ka)%5;
            lhv[m4+4][jg4][2]=img->pic_no-ka;
        }
        ie=4-ISTEP[mode][0];
        for(j=0;j<4;j=j+ISTEP[mode][1])
        {
            j4=jg4+j;
            for(i=0;i<4;i=i+ISTEP[mode][0])
            {
                i4=m4+i;
                for (k=0;k<2;k++)       /* vector prediction. find first koordinate set for pred */
                {
                    int dv1,dv2,denom;

                    /*## <Sharp Start> ##*/

                    /*## motion vector prediction part 
                         all the motion vectors in lhv are represented 
                         as integers in 1/6 pixel accuracy 
                    ##*/

                    /*## add speical process for the first colum of pixels
                         to avoid negative index of iMV. This is a reported
                         bug in telenor h.26L ver1.0 and an alternative 
                         approach to fix the bug has been presented in 
                         telenor h.26L ver1.1 
                    ##*/ 

                    if(i4==0)
                    {
                        if(j4==0)
                        {
                            ip=0;
                        }
                        else
                        {
                            i1=i4;
                            j1=j4-1;
                            i2=i4+ISTEP[mode][0];
                            j2=j4-1;

                            ip0=0;
                            ip1=lhv[i1+BLOCK_SIZE][j1][k];
                            ip2=lhv[i2+BLOCK_SIZE][j2][k];

                            ip=ip0+ip1+ip2-mmin(ip0,mmin(ip1,ip2))-mmax(ip0,mmax(ip1,ip2));
                        }
                    }
                    else
                    {
                        i0=i4-1;
                        j0=j4;
                        i1=i4;
                        j1=j4-1;
                        i2=i4+ISTEP[mode][0];
                        j2=j4-1;

                        /* correction for upper edge */
                        if(j4==0)
                        {
                           i1=i0;
                           i2=i0;
                           j1=j0;
                           j2=j0;
                        }

                        /* correction for unknown vector or ij2 to the right for pic */
                        if(((i==ie)&&(j!=0))||(i2>(img->width_cr/2-1)))
                           i2=i4-1;
                    
                        ip0=lhv[i0+BLOCK_SIZE][j0][k];
                        ip1=lhv[i1+BLOCK_SIZE][j1][k];
                        ip2=lhv[i2+BLOCK_SIZE][j2][k];

                        ip=ip0+ip1+ip2-mmin(ip0,mmin(ip1,ip2))-mmax(ip0,mmax(ip1,ip2));
                    }

                    get_len_info(&len,&info);
 
                    if (len>17)
                        return SEARCH_SYNC;
                   
                    /*## reconstruct the right motion vector 

                         the predicted motion vector in 1/6 pixel accuracy 
                         is first truncted to current motion vector's 
                         accuracy using integer division . 
                         it is then added with the decoded motion vector 
                         difference to reconstruct the current motion 
                         vector. 
                         finally, the current motion vector is represented 
                         in 1/6 pixel accuracy.

                    ##*/

                    denom=Accuracy[img->mb_accuracy];
                    dv1=linfo_mvd(len,info);
                    dv2=mround(ip,denom);
                    iv=(dv1+dv2)*denom;

                    /*## <Sharp End> ##*/

                    for(ii=0;ii<ISTEP[mode][0];ii++)
                    {
                       for(jj=0;jj<ISTEP[mode][1];jj++)
                       {
                          lhv[i4+ii+BLOCK_SIZE][j4+jj][k]=iv;
                       }
                    }
                }
            }
        }
    }

    /*## <Sharp Start> ##*/
 
    /* read CBP if mode different from 0 */      
    get_len_info(&len,&info);
 
    /*## <Sharp End> ##*/
 
    n= (int) pow(2,(len/2))+info-1;
    if (n>47)   /* illegal value, jump to find next sync word */
    {
        printf("Error in index n to array icbp\n");
        return SEARCH_SYNC;        
    }

    icbp=NCBP[n][1-mode/INTRA_MB];

    /* luma koefisients */
    for(j=0;j<BLOCK_SIZE;j++)
    {
        jj=j/2;
        for(i=0;i<BLOCK_SIZE;i++)
        {   
            ii=i/2;
            /* zero all kooef  */
            for(iii=0;iii<BLOCK_SIZE;iii++)
                for(jjj=0;jjj<BLOCK_SIZE;jjj++)
                    img->kof[i][j][iii][jjj]=0;

            if((icbp & (int)pow(2,(ii+2*jj))) != 0)   
            {
                ke=0;
                if((mode==INTRA_MB) && (img->quant<24))
                    ke=1;
                kee=16/(ke+1);
                for(kkk=0;kkk<ke+1;kkk++)
                {
                    kk=-1;
                    len = 0;                        /* just to get inside the loop */ 
                    for(k=0;(k<kee+1) && (len!=1);k++)
                    {
                        /*## <Sharp Start> ##*/
 
                        get_len_info(&len,&info);
 
                        /*## <Sharp End> ##*/

                        if(len>29)
                            return SEARCH_SYNC;         /* illegal length, start sync search */
                        if (len != 1)              /* leave if len=1 */
                        {
                            if (ke==0)
                                linfo_levrun_inter(len,info,&level,&irun);
                            if (ke==1)
                                linfo_levrun_intra(len,info,&level,&irun);
                            kk=kk+irun+1;
                            if (ke==0)
                            {
                                i0=NSCAN1[kk][0];
                                j0=NSCAN1[kk][1];
                            }
                            else
                            {
                                i0=NSCAN2[kk][0][kkk];
                                j0=NSCAN2[kk][1][kkk];
                            }
                        
                        if(kk>(kee-1))
                            return SEARCH_SYNC; 
                        img->kof[i][j][i0][j0]=level*JQ1[img->quant];
                        }
                    }
                }
            }
        }
    }

    /* chroma AC koeffs, all zero fram start */
        
    for (j=4;j<6;j++)
        for (i=0;i<4;i++)
            for (iii=0;iii<4;iii++)
                for (jjj=0;jjj<4;jjj++)
                    img->kof[i][j][iii][jjj]=0;
    if (icbp>31)
    {
        for(j=4;j<6;j++)
        {
            for(i=0;i<4;i++)
            {
                kk=0;
                len=0;
                for(k=0;(k<16)&&(len!=1);k++)
                {

                    /*## <Sharp Start> ##*/
 
                    get_len_info(&len,&info);
 
                    /*## <Sharp End> ##*/

                    if (len>29)
                        return SEARCH_SYNC; 
                    if (len != 1)            
                    {
                        linfo_levrun_inter(len,info,&level,&irun);
                        kk=kk+irun+1;
                        i0=NSCAN1[kk][0];
                        j0=NSCAN1[kk][1];
                        if(kk>15)
                            return SEARCH_SYNC;
                        img->kof[i][j][i0][j0]=level*JQ1[JCHROMA[img->quant]];
                    }
                }
            }
        }
    }
    /* chroma 2x2 DC koeffs */   
    if(icbp>15)
    {
        for (ll=0;ll<3;ll+=2)
        {
            for (i=0;i<4;i++)
                kofu[i]=0;
            
            kk=-1;
            len=0;
            for(k=0;(k<5)&&(len!=1);k++)
            {

                /*## <Sharp Start> ##*/
 
                get_len_info(&len,&info);
 
                /*## <Sharp End> ##*/

                if (len>29)
                    return SEARCH_SYNC; 
                if (len != 1)                         {
                    linfo_levrun_c2x2(len,info,&level,&irun);
                    kk=kk+irun+1;
                    if(kk>3)
                        return SEARCH_SYNC;
                    kofu[kk]=level*JQ1[JCHROMA[img->quant]];
                }
            }
            img->kof[0+ll][4][0][0]=(kofu[0]+kofu[1]+kofu[2]+kofu[3])/2;
            img->kof[1+ll][4][0][0]=(kofu[0]-kofu[1]+kofu[2]-kofu[3])/2;
            img->kof[0+ll][5][0][0]=(kofu[0]+kofu[1]-kofu[2]-kofu[3])/2;
            img->kof[1+ll][5][0][0]=(kofu[0]-kofu[1]-kofu[2]+kofu[3])/2;
        }
    }               
                       
    /* start decoding */ 
    
    /* luma */
    for(j=0;j<BLOCK_SIZE;j++)
    {
        j4=jg4+j;
        for(i=0;i<BLOCK_SIZE;i++)
        {
            i4=m4+i;
            if(mode==INTRA_MB)
            {
                if (intrapred(img,i4,j4)==SEARCH_SYNC)  /* make 4x4 prediction block mpr from given prediction mode */
                    return SEARCH_SYNC;              /* bit error */
            }
            else
            {

                /*## <Sharp Start> ##*/

                /*## luma motion compensation ##*/

                for(ii=0;ii<BLOCK_SIZE;ii++)
                {
                    i2=(i4*4+ii)*6;
                    i1=i2+lhv[i4+BLOCK_SIZE][j4][0];
                    for(jj=0;jj<BLOCK_SIZE;jj++)
                    {
                        j2=(j4*4+jj)*6;
                        j1=j2+lhv[i4+BLOCK_SIZE][j4][1];
                        img->mpr[ii][jj]=mref[i1][j1][nref];
                    }
                }

                /*## <Sharp End> ##*/
            } 
                            
            itrans(img,i,j);      /* use DCT transform and make 4x4 block m7 from prediction block mpr */

            for(ii=0;ii<BLOCK_SIZE;ii++)
                for(jj=0;jj<BLOCK_SIZE;jj++)
                {
                    imgY[i4*BLOCK_SIZE+ii][j4*BLOCK_SIZE+jj][1]=img->m7[ii][jj]; /* contruct picture from 4x4 blocks*/
                }           
        }
    }
    /* chroma */          
    for(uv=0;uv<2;uv++)
    {
        if (mode==INTRA_MB)
        {
            js0=0;
            js1=0;
            js2=0;
            js3=0;
            for(i=0;i<4;i++)
            {
                if(img->jgob>0)
                {
                    js0=js0+imgUV[m8+i][jg8-1][1][uv];
                    js1=js1+imgUV[m8+i+4][jg8-1][1][uv];
                }
                if(img->igob>0)
                {
                    js2=js2+imgUV[m8-1][jg8+i][1][uv];
                    js3=js3+imgUV[m8-1][jg8+i+4][1][uv];
                }
            }
            if((img->igob>=0)&&(img->jgob>=0))
            {
                js[0][0]=(js0+js2+4)/8;
                js[1][0]=(js1+2)/4;
                js[0][1]=(js3+2)/4;
                js[1][1]=(js1+js3+4)/8;
            }
            if((img->igob==0)&&(img->jgob>=0))
            {
                js[0][0]=(js0+2)/4;
                js[1][0]=(js1+2)/4;
                js[0][1]=(js0+2)/4;
                js[1][1]=(js1+2)/4;
            }
            if((img->igob>=0)&&(img->jgob==0))
            {
                js[0][0]=(js2+2)/4;
                js[1][0]=(js2+2)/4;
                js[0][1]=(js3+2)/4;
                js[1][1]=(js3+2)/4;
            }
            if((img->igob==0)&&(img->jgob==0))
            {
                js[0][0]=128;
                js[1][0]=128;
                js[0][1]=128;
                js[1][1]=128;
            }
        }
   
        for (j=4;j<6;j++)
        {
            j4=jg8+(j-4)*4;
            for(i=0;i<2;i++)
            {
                i4=m8+i*4;
                /* make pred */
                if(mode==INTRA_MB)
                {
                    for(ii=0;ii<4;ii++)
                        for(jj=0;jj<4;jj++)
                        {
                            img->mpr[ii][jj]=js[i][j-4];
                        }
                }
                else
                {
                    /*## <Sharp Start> ##*/

                    /*## Chroma motion compensation ##*/

                    for(jj=0;jj<4;jj++)
                    {
                        jf=(j4+jj)/2;
                        for(ii=0;ii<4;ii++)
                        {
                            if1=(i4+ii)/2;
                            lh=lhv[if1+4][jf][0]/2;
                            lv=lhv[if1+4][jf][1]/2;
                            i1=mmin((img->width_cr-1)*6,mmax(0,(i4+ii)*6+lh));
                            j1=mmin((img->height_cr-1)*6,mmax(0,(j4+jj)*6+lv));
                            img->mpr[ii][jj]=mcef[i1][j1][uv][nref];
                        }
                    }

                    /*## <Sharp End> ##*/
                }   
                itrans(img,2*uv+i,j);
                for(ii=0;ii<4;ii++)
                    for(jj=0;jj<4;jj++)
                    {
                        imgUV[i4+ii][j4+jj][1][uv]=img->m7[ii][jj];
                    }
            }
        }
    }  
    return DECODING_OK;
}       
    
    
int linfo_mvd(int len,int info)                /* make signed value */ 
{
    int n;
    int signed_mvd;
    
    n = (int)pow(2,(len/2))+info-1;       
    signed_mvd = (n+1)/2;
    if((n & 0x01)==0)                           /* lsb is signed bit */
        signed_mvd = -signed_mvd;
    
    return signed_mvd;
}



    
    
