
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
 *
 *  ldecod.c
 *  Main program for H.26L decoder
 *  Copyright (C) 1999  Telenor Satellite Services, Norway
 *  
 *  Contacts: 
 *  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
 *
 *  Telenor Satellite Services 
 *  Keysers gt.13                        tel.:   +47 23 13 86 98
 *  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
 *  
 ************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <sys/timeb.h>

#include "global.h" 
#include "ldecod.h" 

void main(int argc, char **argv) 
{ 
    FILE *fd;                       /* pointer to input configuration file */
    FILE *p_in;                     /* pointer to input H.26L bitstream file */
    FILE *p_out;                    /* pointer to output YUV file */
    FILE *p_log;                    /* pointer to output log file */
    FILE *p_ref;                    /* pointer to input original reference YUV file file */
  
    char config_filename[100];      /* configuration filename */

    time_t ltime1;                  /* for time measurement */
    time_t ltime2;
    struct timeb tstruct1;
    struct timeb tstruct2;
    char timebuf[128];
    int tot_time=0;                 /* time for total encoding session */
    int tmp_time;                   /* time used by decoding the last frame */

    struct inp_par    *inp;         /* input parameters from input configuration file */
    struct snr_par    *snr;  
    struct img_par    *img;

    /* allocate memory for the structures */
    inp =  (struct inp_par *)calloc(1, sizeof(struct inp_par)); 
    snr =  (struct snr_par *)calloc(1, sizeof(struct snr_par));
    img =  (struct img_par *)calloc(1, sizeof(struct img_par));
     
    if (argc != 2) 
    {
        fprintf(stdout,"Usage: %s <config.dat> \n",argv[0]);
        fprintf(stdout,"<config.dat> defines encoder parameters\n");
        exit(-1);
    }
    strcpy(config_filename,argv[1]);
    if((fd=fopen(config_filename,"r")) == NULL)           /* read the decoder configuration file */
    {
        fprintf(stdout,"Error: Control file %s not found\n",config_filename);
        exit(0);
    }

    fscanf(fd,"%s",inp->infile);                /* YUV 4:2:2 input format */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%s",inp->outfile);               /* H.26L compressed output bitsream */
    fscanf(fd,"%*[^\n]");
      
    fscanf(fd,"%s",inp->reffile);               /* reference file */
    fscanf(fd,"%*[^\n]");
    
    fscanf(fd,"%d",&inp->postfilter);           /* postfilter on/off */
    fscanf(fd,"%*[^\n]");

    fscanf(fd,"%d",&inp->write_bmp);            /* make images in bitmap format */
    fscanf(fd,"%*[^\n]");
    
    if ((p_in=fopen(inp->infile,"rb"))==0)
    {
        fprintf(stdout,"Input file %s does not exist \n",inp->infile);
        exit(0);
    }
    if ((p_out=fopen(inp->outfile,"wb"))==0)  
    {
        fprintf(stdout,"Error open file %s  \n",inp->outfile);
        exit(0);
    }
     
    fprintf(stdout,"--------------------------------------------------------------------------\n");
    fprintf(stdout," Decoder config file                    : %s \n",config_filename);
    fprintf(stdout,"--------------------------------------------------------------------------\n");
    fprintf(stdout," Input H.26L bitstream                  : %s \n",inp->infile);
    fprintf(stdout," Output decoded YUV 4:2:0               : %s \n",inp->outfile);
    fprintf(stdout," Output status file                     : log_dec.dat \n");
    if ((p_ref=fopen(inp->reffile,"rb"))==0)
    {
        fprintf(stdout," Input reference file                   : %s does not exist \n",inp->reffile);
        fprintf(stdout,"                                          SNR values are not available\n");
    }
    else
        fprintf(stdout," Input reference file                   : %s \n",inp->reffile);
    fprintf(stdout,"--------------------------------------------------------------------------\n");

    
	fprintf(stdout,"Frame  TR    QP   SnrY    SnrU    SnrV    Time(ms)\n");
    
    img->pic_no=0;                         
    
    /*## <Sharp Start> ##*/

    read_bitstream(p_in);   /* read whole bit stream into buffer */
    end_of_sequence=0;

    while (1)      /* while not end of seqence, read next image to buffer */
    {   
        int val;

        ftime( &tstruct1 );                            /* start time ms */
        time( &ltime1 );                               /* start time s  */
                  
        val=image(img,inp);   /* decode next frame */

        if(end_of_sequence)   /* eos */
          break;

        if(val==SEARCH_SYNC)             
            fprintf(stdout,"Biterror in frame %d, looking for synkword for next frame\n",img->pic_no);                    
        else
        {  
            if (p_ref)                          
                find_snr(snr,img,p_ref,inp->postfilter);   /* if ref sequence exist */
            
            time( &ltime2 );                               /* end time sec */
            ftime( &tstruct2 );                           /* end time ms  */
            tmp_time=(ltime2*1000+tstruct2.millitm) - (ltime1*1000+tstruct1.millitm);
            tot_time=tot_time + tmp_time;
 
            fprintf(stdout," %2d %5d %5d %7.3f %7.3f %7.3f %6d\n",
                img->pic_no,img->tr,img->quant,snr->snr_y,snr->snr_u,snr->snr_v,tmp_time); 

            write_frame(img->icif,inp->postfilter,p_out);       /* write image to output YUV file */
        }
         img->pic_no++;                                  /* frame counter */ 

        reset_word_counter();
    }

    /*## <Sharp End> ##*/
    
    fprintf(stdout,"-------------------- Average SNR all frames ------------------------------\n");
    fprintf(stdout," SNR Y(dB)     : %5.2f\n",snr->snr_ya);
    fprintf(stdout," SNR U(dB)     : %5.2f\n",snr->snr_ua);
    fprintf(stdout," SNR V(dB)     : %5.2f\n",snr->snr_va);
    fprintf(stdout,"--------------------------------------------------------------------------\n");
    fprintf(stdout,"Exit decoder, Telenor H.26L proposal, version 1.0\n");               

    /* 
        write to log file 
    */
    if (fopen("log_dec.dat","r")==0)                        /* check if file exist */
    {
        if ((p_log=fopen("log_dec.dat","a"))==0) 
        {
            fprintf(stdout,"Error open file %s for appending\n",p_log);
            exit(0);
        }
        else                                                /* Create header to new file */
        {
            fprintf(p_log," ----------------------------------------------------------------------------------------------------\n");
            fprintf(p_log,"|  Decoder statistics. This file is made first time the encoder is used, later runs are appended     |\n");  
            fprintf(p_log," ---------------------------------------------------------------------------------------------------- \n");
            fprintf(p_log,"| Date  | Time  |    Sequence        |#Img|Format|Postfiler|SNRY 1|SNRU 1|SNRC 1|SNRV N|SNRU N|SNRV N|\n");
            fprintf(p_log," ----------------------------------------------------------------------------------------------------\n");
        }
    }
    else 
        p_log=fopen("log_dec.dat","a");                     /* File exist,just open for appending */                      
    
    /*
      _strdate( timebuf );    
    fprintf(p_log,"| %1.5s |",timebuf );
    
    _strtime( timebuf);    
    fprintf(p_log," % 1.5s |",timebuf);
    */

    fprintf(p_log,"%20.20s|",inp->infile);
    
    fprintf(p_log,"%3d |",img->pic_no);
    
    if(img->icif==0)
        fprintf(p_log," QCIF |");
    else
        fprintf(p_log," CIF  |");
  
    if (inp->postfilter==1)
        fprintf(p_log,"   ON    |");
    else
        fprintf(p_log,"   OFF   |");
    
    fprintf(p_log,"%6.3f|",snr->snr_y1);
    fprintf(p_log,"%6.3f|",snr->snr_u1);
    fprintf(p_log,"%6.3f|",snr->snr_v1);
    fprintf(p_log,"%6.3f|",snr->snr_ya);
    fprintf(p_log,"%6.3f|",snr->snr_ua);
    fprintf(p_log,"%6.3f|\n",snr->snr_va); 
}



