
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

/************************************************************************
*
*  image.cpp for H.26L decoder. 
*  Copyright (C) 1999  Telenor Satellite Services, Norway
*  
*  Contacts: 
*  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
*
*  Telenor Satellite Services 
*  Keysers gt.13                        tel.:   +47 23 13 86 98
*  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
*  
************************************************************************/

#include <stdio.h>
#include <math.h>

#include "global.h"
#include "image.h"

int image(struct img_par *img,struct inp_par *inp)
{   
    int len,info;
    int igobe,jgobe;
    int i,k;
    
    if (img->pic_no==0)                        
    {	
        for (i=0; i <= 255; ++i) 
        {
            int i2;
            i2=mmin(i*i,5000);                   /* initilize quad matrix used in snr routine */
            quad[i]=i2;
        }
        for (k=0;k<6;k++)
            for (i=1;i<101;i++)
            {
                int ii;
                ii=mmin(k,i);
                ltab[i+300][k]=ii;
                ltab[300-i][k]=-ii;              /* initilize ltab matrix used in postfilter routine */
            }        
    }

    /*## <Sharp Start> ##*/
    
    get_len_info(&len,&info);

    if(end_of_sequence)           /* check if eos */
    {
      return DECODING_OK;
    }

    if(img->pic_no==0)
    {
        img->icif=(info&ICIF_MASK)>>1;  /* image format, 0= QCIF, 1=CIF  */
    }

    /*## <Sharp End> ##*/

    img->quant=(info&QP_MASK)>>2;           /* read quant parameter for current frame	*/
    img->tr=(info&TR_MASK)>>7;              /* 8 bit temporal reference */    
    
    /*## <Sharp Start> ##*/
    
    get_len_info(&len,&info);

    /*## <Sharp End> ##*/
    
    img->pic_type = (int) pow(2,(len/2))+info-1;    /* find image type */ 

    if (img->icif == QCIF)                       
    {
        igobe = NO_QCIF_MB_I;                                          
        jgobe = NO_QCIF_MB_J;
    }
    else  /* CIF */                                       
    {
        igobe = NO_CIF_MB_I;                                     
        jgobe = NO_CIF_MB_J;
    }
    
    img->width = igobe*MB_BLOCK_SIZE;
    img->width_cr = igobe*MB_BLOCK_SIZE/2;
    img->height = jgobe*MB_BLOCK_SIZE;
    img->height_cr = jgobe*MB_BLOCK_SIZE/2;    
       
    for (img->jgob=0;img->jgob<jgobe;img->jgob++)
        for (img->igob=0;img->igob<igobe;img->igob++)
        {
            if(macroblock(img)==SEARCH_SYNC)  
                return SEARCH_SYNC;              /* error in bitstream, look for synk word next frame */
        }

    if (img->pic_type==INTRA_IMG)                 /* add loop filter only to intra frames */  
        loopfilter(img);
              
    /*## <Sharp Start> ##*/

    onesixthpix(img);                             /*## 1/6 pixel up-sampling ##*/

    /*## <Sharp End> ##*/

    if (inp->postfilter)
       postfilter(img);                         /* add postfiler to image, gives as input parameter */
    
    if (inp->write_bmp && img->pic_no<100)             
        write_bmp(img,inp->postfilter);                          
     
    return DECODING_OK;   
}


/*## <Sharp Start> ##*/

/*## 1/6 pixel up-sampling using cubic interpolator ##*/

void onesixthpix(struct img_par *img)
{
    int in[4];
    int jn[4];

    float is;
    int i,j,ii,jj,iii,jjj;
    int i1,j1,ij,i2,j2;
    int uv;
        
    /* luma */

    img->np0=(img->pic_no)%5;

    for (i=0; i<img->width ;i++)
    {
        in[0]=mmax(0,i-1);
        in[1]=i;
        in[2]=mmin(img->width-1,i+1);
        in[3]=mmin(img->width-1,i+2);
        i2=i*6;
        for(j=0;j<img->height;j++)
        {
            jn[0]=mmax(0,j-1);
            jn[1]=j;
            jn[2]=mmin(img->height-1,j+1);
            jn[3]=mmin(img->height-1,j+2);
            j2=j*6;
            for(ii=0;ii<=5;ii++)
                for(jj=0;jj<=5;jj++)
                {
                    is=0.0;
                    for(iii=-1;iii<3;iii++)
                    {
                        for(jjj=-1;jjj<3;jjj++)
                        {
                            is+=imgY[in[iii+1]][jn[jjj+1]][1]*LF[iii+1][ii]*LF[jjj+1][jj];
                        }
                    }
                    mref[i2+ii][j2+jj][img->np0]=mmax(0,mmin((int)(is+0.5),255));
                }
        }
    }
   
    /* chroma */

    for (uv=0;uv<2;uv++)
    {
        for(i=0;i<img->width_cr;i++)
        {
            in[0]=mmax(0,i-1);
            in[1]=i;
            in[2]=mmin(img->width_cr-1,i+1);
            in[3]=mmin(img->width_cr-1,i+2);
            i2=i*6;

            for(j=0;j<img->height_cr;j++)
            {
                jn[0]=mmax(0,j-1);
                jn[1]=j;
                jn[2]=mmin(img->height_cr-1,j+1);
                jn[3]=mmin(img->height_cr-1,j+2);
                j2=j*6;

                for (ii=0; ii <= 5; ++ii)
                {
                    for (jj=0; jj <= 5; ++jj)
                    {
                        is=0.0;
                        for (iii=0; iii <= 3; ++iii)
                        {
                            for (jjj=0; jjj <= 3; ++jjj)
                            {
                                is += imgUV[in[iii]][jn[jjj]][1][uv]*LF[iii][ii]*LF[jjj][jj];
                            }
                        }
                        mcef[i2+ii][j2+jj][uv][img->np0]= mmax(0,mmin((int)(is+0.5),255));
                    }
                }
            }
        }
    }
}

/*## <Sharp End> ##*/

void postfilter(struct img_par *img)
{  
    int i_1,i_2,j_1,j_2,uv;
    int i,j,ip1,ip2,jp1,jp2;
    int it,is;
 
    /* postfiler horisontal luma */
    for(i=0;i<img->width;i++)
	{
		i_2=mmax(0,i-2);
		i_1=mmax(0,i-1);
		ip2=mmin(img->width-1,i+2);
		ip1=mmin(img->width-1,i+1);
		it=istr[img->quant][((i+3)&2)/2];

		
        for(j=0;j<img->height;j++)                                   /* avoid two pels on edge */
        {
            is = (imgY[i_2][j][1]+imgY[ip2][j][1]+2*(imgY[i_1][j][1]+imgY[ip1][j][1])-6*imgY[i][j][1])/8;
            imgY[i][j][2]=imgY[i][j][1]+ltab[is+300][it];           /* temp array */
        }
	} 

   for(j=0;j<img->height;j++)
   {
        j_2=mmax(0,j-2);
		j_1=mmax(0,j-1);
        jp2=mmin(img->height-1,j+2);
        jp1=mmin(img->height-1,j+1);
        it=istr[img->quant][((j+3)&2)/2];
        for(i=0;i<img->width;i++)
        {
        is = (imgY[i][j_2][2]+imgY[i][jp2][2]+2*(imgY[i][j_1][2]+imgY[i][jp1][2])-6*imgY[i][j][2])/8;
        imgY[i][j][0] = imgY[i][j][2]+ltab[is+300][it];
        }
   }
       
   /* horisontal chroma */
   for (uv=0;uv<2;uv++)
   {
       for(i=0;i<img->width_cr;i++)
       {
           i_2=mmax(0,i-2);
           i_1=mmax(0,i-1);
           ip2=mmin(img->width_cr-1,i+2);
           ip1=mmin(img->width_cr-1,i+1);
           it=istr[img->quant][((i+3)&2)/2];
           for(j=0;j<img->height_cr;j++) /* avoid two first and last lines */
           {
               is = (imgUV[i_2][j][1][uv]+imgUV[ip2][j][1][uv]+2*(imgUV[i_1][j][1][uv]+imgUV[ip1][j][1][uv])-6*imgUV[i][j][1][uv])/8;
               imgUV[i][j][2][uv] = imgUV[i][j][1][uv]+ltab[is+300][it];  /* temp array */
           }
       /* postfiler vertical chroma */
       } 
       for(j=0;j<img->height_cr;j++)
       {
           j_2=mmax(0,j-2);
           j_1=mmax(0,j-1);
           jp2=mmin(img->height_cr-1,j+2);
           jp1=mmin(img->height_cr-1,j+1);
           it=istr[img->quant][((j+3)&2)/2];
           for(i=0;i<img->width_cr;i++) /* avoid two first and last lines */
           {
               is = (imgUV[i][j_2][2][uv]+imgUV[i][jp2][2][uv]+2*(imgUV[i][j_1][2][uv]+imgUV[i][jp1][2][uv])-6*imgUV[i][j][2][uv])/8;
               imgUV[i][j][0][uv] = imgUV[i][j][2][uv]+ltab[is+300][it];
           }
       }
   }
}

void loopfilter(struct img_par *img)
{  
    int i,j,id,uv;

    /* luma hor */
    for(j=0;j<img->height;j++)
        for(i=3;i<img->width-1;i+=4)
            {
                id=(imgY[i-1][j][1]-imgY[i+2][j][1]-4*(imgY[i][j][1]-imgY[i+1][j][1]))/8;
                id=ltab[id+300][istr[img->quant][1]];
                imgY[i][j][1]=mmax(0,mmin(255,imgY[i][j][1]+id));
                imgY[i+1][j][1]=mmax(0,mmin(255,imgY[i+1][j][1]-id));
            }
    /* luma vert */
    for(i=0;i<img->width;i++)
        for(j=3;j<img->height-1;j+=4)
        {
            id=(imgY[i][j-1][1]-imgY[i][j+2][1]-4*(imgY[i][j][1]-imgY[i][j+1][1]))/8;
            id=ltab[id+300][istr[img->quant][1]];
            imgY[i][j][1]=mmax(0,mmin(255,imgY[i][j][1]+id));
            imgY[i][j+1][1]=mmax(0,mmin(255,imgY[i][j+1][1]-id));
        }
        
   
    for(uv=0;uv<2;uv++)
    { 
        /* chroma hor */
        for(j=0;j<img->height_cr;j++)
            for(i=3;i<img->width_cr-1;i+=4)
            {
                id=(imgUV[i-1][j][1][uv]-imgUV[i+2][j][1][uv]-4*(imgUV[i][j][1][uv]-imgUV[i+1][j][1][uv]))/8;
                id=ltab[id+300][istr[img->quant][1]];
                imgUV[i][j][1][uv]=mmax(0,mmin(255,imgUV[i][j][1][uv]+id));
                imgUV[i+1][j][1][uv]=mmax(0,mmin(255,imgUV[i+1][j][1][uv]-id));
            }
       /* chroma vert */
       for(i=0;i<img->width_cr;i++)
           for(j=3;j<img->height_cr-1;j+=4)
            {
               id=(imgUV[i][j-1][1][uv]-imgUV[i][j+2][1][uv]-4*(imgUV[i][j][1][uv]-imgUV[i][j+1][1][uv]))/8;
               id=ltab[id+300][istr[img->quant][1]];
               imgUV[i][j][1][uv]=mmax(0,mmin(255,imgUV[i][j][1][uv]+id));
               imgUV[i][j+1][1][uv]=mmax(0,mmin(255,imgUV[i][j+1][1][uv]-id));
           }
    }
}


void find_snr(struct snr_par *snr,struct img_par *img,FILE *p_ref,int postfilter)
{
      
    int i,j;
    int diff_y,diff_u,diff_v;
    int i2,uv;
    int skip_frame;
    static byte tr_old=0;
    int filterindex;
    
    /*  Calculate  PSNR for Y and U,V. */
    
    /*     Luma. */
  
    /* 
    Input one new frame from the original sequence.  
    Read inp->jumpd frames to reflect frame skipping.
    */
   
    
    if (img->pic_type== INTRA_IMG)
        skip_frame= 1;                                        /* start with the first frame */
    else
    {
        /*## <Sharp Start> ##*/
 
        if(img->tr >= tr_old)
        {
           skip_frame =  (byte)img->tr - (byte)tr_old % 256; /* skip frames which are not encoded */ 
        }                                                    /* tr wraps at 256 */
        else
        {
           skip_frame = (byte)img->tr+256 - (byte)tr_old %256;
        }

        /*## <Sharp End> ##*/

        tr_old = img->tr;                                    
    }

    for (i2=0; i2 < skip_frame; ++i2) 
    {
        for (j=0; j < img->height; ++j) 
        {
            for (i=0; i < img->width; ++i) 
            {
                imgY[i][j][3]=fgetc(p_ref);
            }
        }
        for (uv=0; uv < 2; ++uv) 
        {
            for (j=0; j < img->height_cr ; ++j) 
            {
                for (i=0; i < img->width_cr; ++i) 
                {
                    imgUV[i][j][3][uv]=fgetc(p_ref);
                }
            }
        }
    }
    if (postfilter)
        filterindex=0;
    else
        filterindex=1;

    
    diff_y=0;
    for (i=0; i < img->width; ++i) 
    {
        for (j=0; j < img->height; ++j) 
        {
            diff_y += quad[abs(imgY[i][j][filterindex]-imgY[i][j][3])];
        }
    }
    
    /*  Chroma */
    
    diff_u=0;
    diff_v=0;
    
    for (i=0; i < img->width_cr; ++i) 
    {
        for (j=0; j < img->height_cr; ++j) 
        {
            diff_u += quad[abs(imgUV[i][j][filterindex][0]-imgUV[i][j][3][0])];
            diff_v += quad[abs(imgUV[i][j][filterindex][1]-imgUV[i][j][3][1])];
        }
    }

    
    /*  Collecting SNR statistics */
    
    if (diff_y != 0)
    {   
        snr->snr_y=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)diff_y));        /* luma snr for current frame */

    }
    
    if (diff_u != 0)
    {
        snr->snr_u=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)(4*diff_u)));    /*  chroma snr for current frame  */
        snr->snr_v=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)(4*diff_v)));    /*  chroma snr for current frame  */

    }
    
    
    if (img->pic_no == 0) /* first */
    {
        snr->snr_y1=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)diff_y));       /* keep luma snr for first frame */ 
        snr->snr_u1=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)(4*diff_u)));   /* keep chroma snr for first frame */ 
        snr->snr_v1=(float)(10*log10(65025*(float)(img->width)*(img->height)/(float)(4*diff_v)));   /* keep chroma snr for first frame */ 
        snr->snr_ya=snr->snr_y1;
        snr->snr_ua=snr->snr_u1;
        snr->snr_va=snr->snr_v1;
    } 
    else 
    {
        snr->snr_ya=(float)(snr->snr_ya*img->pic_no+snr->snr_y)/(img->pic_no+1);      /* average snr chroma for all frames except first */
        snr->snr_ua=(float)(snr->snr_ua*img->pic_no+snr->snr_u)/(img->pic_no+1);      /* average snr luma for all frames except first  */
        snr->snr_va=(float)(snr->snr_va*img->pic_no+snr->snr_v)/(img->pic_no+1);      /* average snr luma for all frames except first  */
    }
} 
  
