
/*****************************************************************************/
/*                                                                           */
/*      Copyright (C) 1999 SHARP LABS OF AMERICA All Rights Reserved.        */
/*                                                                           */
/*****************************************************************************/

/* Copyright (C) 1997 by Sharp Laboratories of America, Camas, WA 98607, USA.
   All Rights Reserved.

   The sections in this program that are contained within the headings:  */

   /*## <Sharp Start> ##*/


   /*## <Sharp End> ##*/

/* are copyrighted by Sharp Laboratories of America. It may not be redistributed 
   without the consent of the copyright holders. In no circumstances may the 
   copyright notice be removed. The program may not be used without a written 
   permission of the copyright holders.  The users shall treat the program in 
   confidence. This program is provided as is, without any express or implied 
   warranty, without even the warranty of fitness for a particular purpose.
   */

/*****************************************************************************/

 /************************************************************************
 *
 *  global.cpp for H.26L decoder. 
 *  Copyright (C) 1999  Telenor Satellite Services, Norway
 *  
 *  Contacts: 
 *  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
 *  
 *
 *  Telenor Satellite Services 
 *  Keysers gt.13                        tel.:   +47 23 13 86 98
 *  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
 *  
 ************************************************************************/
#ifndef _GLOBAL_H_
#define _GLOBAL_H_

#include <stdio.h>                          /* for FILE */

#define FALSE           0
#define TRUE            1

typedef unsigned char   byte;                /*  8 bit unsigned */

#define LEN_PSC         31                   /* uniqe length of startcode, defines new picture */  

#define INTER_IMG_1     0               
#define INTER_IMG_MULT  1       
#define INTRA_IMG       2       

/*## <Sharp Start> ##*/

/* motion accuracy mode */
#define INTEGER         0
#define HALF            1
#define ONE_THIRD       2
#define ONE_SIXTH       3

/*## <Sharp End> ##*/

#define COPY_MB         0                    /* just copy last MB, no motion vectors */  
#define M16x16_MB       1                    /* block sizes for inter motion search  */
#define M16x8_MB        2   
#define M8x16_MB        3
#define M8x8_MB         4
#define M8x4_MB         5   
#define M4x8_MB         6
#define M4x4_MB         7
#define INTRA_MB        9                    /* intra coded MB in inter frame */     

#define BLOCK_SIZE      4
#define MB_BLOCK_SIZE   16

#define LINES_QCIF      144
#define PELS_QCIF       176
#define LINES_CIF       288
#define PELS_CIF        352

#define NO_QCIF_MB_I    11    
#define NO_QCIF_MB_J    9
#define NO_CIF_MB_I     22
#define NO_CIF_MB_J     18

#define QCIF            0                       /* image format */
#define CIF             1
                                                
#define EOS_MASK        0x01                    /* mask for end of sequence (bit 1)         */
#define ICIF_MASK       0x02                    /* mask for image format (bit 2)            */
#define QP_MASK         0x7C                    /* mask for quant.parameter (bit 3->7)      */
#define TR_MASK         0x7f80                  /* mask for temporal referance (bit 8->15)  */

#define MAX_NO_OF_COEF  17    

#define DECODING_OK     0
#define SEARCH_SYNC     1

#define MIN_PIX_VAL     0                       /* lowest legal values for 8 bit sample     */ 
#define MAX_PIX_VAL     255                     /* highest legal values for 8 bit sample    */ 

#define mmax(a, b)      ((a) > (b) ? (a) : (b)) /* Macro returning max value                */
#define mmin(a, b)      ((a) < (b) ? (a) : (b)) /* Macro returning min value                */
#define mround(x,q)     ((x)/q)


extern byte imgY[352][288][4];                   /* external array for the luma component   */      
extern byte imgUV[176][144][4][2];               /* external array for the chroma component  */

/*## <Sharp Start> ##*/

extern byte mref[2112][1728][5];                 /* 1/6 pix luma */
extern byte mcef[1056][864][2][5];               /* 1/6 pix chroma */
extern int  end_of_sequence;

/*## <Sharp End> ##*/

/* image parameters */
struct img_par
{ 
    int pic_no;                                  /* frame number                            */    
    int icif;                                    /* frame format                            */   
    int tr;                                      /* temporal reference, 8 bit, wrapps at 255*/
    int quant;                                   /* quant for the current frame             */
    int pic_type;                                /* image type CIF or QCIF                  */   
    int width;
    int height;
    int width_cr;                                /* width chroma */
    int height_cr;                               /* height chroma */
    int np0;  
    int jgob;
    int igob;     
    int mpr[4][4];                               /* predicted 4x4 block                     */
    int m7[4][4];                                /* final 4x4 block                         */
    int kof[4][6][4][4];                         /* correction coefficients from predicted  */ 
    int jpred[89][73];                           /* prediction type                         */

/*## <Sharp Start> ##*/

    int mb_accuracy;                             /*## motion vector accuracy in the MB    ##*/

/*## <Sharp End> ##*/
};

/* signal to noice ratio parameters */
struct snr_par         
{
    float snr_y;                                 /* current Y SNR                           */      
    float snr_u;                                 /* current U SNR                           */
    float snr_v;                                 /* current V SNR                           */
    float snr_y1;                                /* SNR Y(dB) first frame                   */
    float snr_u1;                                /* SNR U(dB) first frame                   */
    float snr_v1;                                /* SNR V(dB) first frame                   */
    float snr_ya;                                /* Average SNR Y(dB) remaining frames      */
    float snr_ua;                                /* Average SNR U(dB) remaining frames      */
    float snr_va;                                /* Average SNR V(dB) remaining frames      */
};

/* input parameters from configuration file */
struct inp_par                    
{
   char infile[100];                             /* Telenor H.26L input                     */
   char outfile[100];                            /* Decoded YUV 4:2:0 output                */
   char reffile[100];                            /* Optional YUV 4:2:0 reference file for SNR measurement */
   int postfilter;                               /* postfilter (0=OFF,1=ON)                 */
   int write_bmp;                                /* write images in bitmap format           */ 
};


/* prototypes */
int     read_bitstream(FILE *p_in);
void    write_frame(int,int,FILE *p_out); 
void    itrans(struct img_par *img,int i0,int j0);
int     intrapred(struct img_par *img,int i4,int j4);
void    postfilter(struct img_par *img);
void    loopfilter(struct img_par *img);
int     macroblock(struct img_par *img);
int     linfo_mvd(int len,int info);
int     image(struct img_par *img,struct inp_par *inp);
void    linfo_levrun_inter(int len,int info,int *level,int *irun);
void    linfo_levrun_intra(int len,int info,int *level,int *irun);
void    linfo_levrun_c2x2(int len,int info,int *level,int *irun);
void    find_snr(struct snr_par *snr,struct img_par *img, FILE *p_ref, int postfilter);

void write_bmp(struct img_par *img,int postfilter);            /* write standard 24 bit bitmap format,just for debugging */

/*## <Sharp Start> ##*/

void    onesixthpix(struct img_par *img);        /*## 1/6 pixel up-sampling ##*/
int     get_len_info();
int     get_212vlc_len_info();
void    reset_word_counter();

/*## <Sharp End> ##*/

#endif
