/************************************************************************
 *
 *  block.cpp for H.26L decoder. 
 *  Copyright (C) 1999  Telenor Satellite Services, Norway
 *  
 *  Contacts: 
 *  Inge Lille-Langy               <Inge.Lille-Langoy@oslo.satellite.telenor.no>
 * 
 *
 *  Telenor Satellite Services 
 *  Keysers gt.13                        tel.:   +47 23 13 86 98
 *  N-0130 Oslo, Norway                  fax.:   +47 22 77 79 80
 *  
 ************************************************************************/

#include "block.h"
    
int intrapred(struct img_par *img,int i4,int j4)            
{   
    int js0,js1,js2,i,j;
    int i0,j0,j41,i41,j42,i42;
    int ia[7];
    
    byte predmode;

    predmode=img->jpred[i4+1][j4+1];
    
    i41=i4*4;
    j41=j4*4;
    i0=i41-1;
    j0=j41-1;
    
    i42=img->jpred[i4][j4+1];
    j42=img->jpred[i4+1][j4];

    switch (predmode) 
    {
    case DC_PRED:							/* DC prediction */ 
        
        js1=0;
        js2=0;
        for (i=0;i<BLOCK_SIZE;i++)
        {
            if (j42>=0)
                js1=js1+imgY[i41+i][j41-1][1];
            if (i42>=0)
                js2=js2+imgY[i41-1][j41+i][1];
        }
        if((i42>=0)&(j42>=0))				/* make DC prediction from both block above and to the left */
            js0=(js1+js2+4)/8;
        if((i42>=0)&(j42<0))
            js0=(js2+2)/4;			    	/* make DC prediction from block to the left */
        if((i42<0)&(j42>=0))    
            js0=(js1+2)/4;			    	/* make DC prediction from block above */
        if((i42<0)&(j42<0))
            js0=128;				    	/* current block is the upper left */
                                            /* no block to make DC pred.from */        
        for(i=0;i<BLOCK_SIZE;i++)
            for(j=0;j<BLOCK_SIZE;j++)
                img->mpr[i][j]=js0;		    /* store predicted 4x4 block */
        break;
            
            
    case VERT_PRED:							/* vertical prediction from block above */
        for(j=0;j<BLOCK_SIZE;j++)
            for(i=0;i<BLOCK_SIZE;i++)
                img->mpr[i][j]=imgY[i41+i][j41-1][1];/* store predicted 4x4 block */
        break;
            
    case HOR_PRED:							/* horisontal prediction from left block */
        for(j=0;j<BLOCK_SIZE;j++)
            for(i=0;i<BLOCK_SIZE;i++)
                img->mpr[i][j]=imgY[i41-1][j41+j][1];       /* store predicted 4x4 block */
        break;
            
    case DIAG_PRED_LR:							/* diagonal prediction from left to right */    
        ia[0]=(imgY[i0][j41+3][1]+2*imgY[i0][j41+2][1]+imgY[i0][j41+1][1]+2)/4;
        ia[1]=(imgY[i0][j41+2][1]+2*imgY[i0][j41+1][1]+imgY[i0][j41+0][1]+2)/4;
        ia[2]=(imgY[i0][j41+1][1]+2*imgY[i0][j41+0][1]+imgY[i0][j41-1][1]+2)/4;
        ia[3]=(imgY[i0][j41+0][1]+2*imgY[i0][j41-1][1]+imgY[i41+0][j0][1]+2)/4;
        ia[4]=(imgY[i41-1][j0][1]+2*imgY[i41+0][j0][1]+imgY[i41+1][j0][1]+2)/4;
        ia[5]=(imgY[i41+0][j0][1]+2*imgY[i41+1][j0][1]+imgY[i41+2][j0][1]+2)/4;
        ia[6]=(imgY[i41+1][j0][1]+2*imgY[i41+2][j0][1]+imgY[i41+3][j0][1]+2)/4;
        for(i=0;i<4;i++)
            for(j=0;j<4;j++)
                img->mpr[i][j]=ia[i-j+3];
        break;
            
    case DIAG_PRED_RL:							/* diagonal prediction from  right to left */ 
        ia[0]=(imgY[i0][j41+1][1]+imgY[i41+1][j0][1])/2;
        ia[1]=(imgY[i0][j41+2][1]+imgY[i41+2][j0][1])/2;
        ia[2]=(imgY[i0][j41+3][1]+imgY[i41+3][j0][1])/2;
        ia[3]=ia[2];           
        ia[4]=ia[2];           
        ia[5]=ia[2];           
        ia[6]=ia[2];           
        for(i=0;i<BLOCK_SIZE;i++)
            for(j=0;j<BLOCK_SIZE;j++)
            {
                img->mpr[i][j]=ia[i+j];
            }
        break;
    
    default:
        {                                       /* indication of fault in bitstream,exit */ 
        printf("Error: illegal prediction mode input: %d\n",predmode);  
        return SEARCH_SYNC;
        }
    }
    return DECODING_OK;
}

void itrans(struct img_par *img,int i0,int j0)  /* transforms kof to m7 */
{
    int i,j,i1,j1;
    int m5[4];
    int m6[4];
    
    /* horisontal */
    for (j=0;j<BLOCK_SIZE;j++)
    {   
        for (i=0;i<BLOCK_SIZE;i++)
		{
            m5[i]=img->kof[i0][j0][i][j];
        }
        m6[0]=(m5[0]+m5[2])*13;
        m6[1]=(m5[0]-m5[2])*13;
        m6[2]=m5[1]*7-m5[3]*17;
        m6[3]=m5[1]*17+m5[3]*7;

        for (i=0;i<2;i++)
        {
            i1=3-i;
            img->m7[i][j]=m6[i]+m6[i1];
            img->m7[i1][j]=m6[i]-m6[i1];
        }
    }
    /* vertical */
    for (i=0;i<BLOCK_SIZE;i++)
    {   
        for (j=0;j<BLOCK_SIZE;j++)
            m5[j]=img->m7[i][j];
        
        m6[0]=(m5[0]+m5[2])*13;
        m6[1]=(m5[0]-m5[2])*13;
        m6[2]=m5[1]*7-m5[3]*17;
        m6[3]=m5[1]*17+m5[3]*7;
        
        for (j=0;j<2;j++)
        {
            j1=3-j;
            img->m7[i][j]=mmax(0,mmin(255,(m6[j]+m6[j1]+img->mpr[i][j]*JQQ+JQQ2)/JQQ));
            img->m7[i][j1]=mmax(0,mmin(255,(m6[j]-m6[j1]+img->mpr[i][j1]*JQQ+JQQ2)/JQQ));
        }

    }
   
}

