#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#define GLOBAL
#include "config.h"
#include "tmndec.h"
#include "global.h"

extern unsigned char *DitherData_;

struct _VideoFrame {
       		                 unsigned char *Raw[2];
                		 unsigned char *refframe[3];     
                		 unsigned char *oldrefframe[3];
                		 unsigned char *bframe[3];
	                    }VideoFrameData[8];
static int WindowData[8];
int DstWindow=0;

/* must be init b4 use */
static void H263Calloc(int );
static void H263Free(int );
void initdecoder(int);
int h263(unsigned char *,int ,unsigned char *);


int h263(unsigned char *Src,int FrameLength,unsigned char *Dst)
{
int framenum=0;
int i,h,v;

		ld->InData = Src;
		ld->InFrameSize = FrameLength;

		if (WindowData[DstWindow]==0) H263Calloc(DstWindow);
		else if (FrameLength<0) 
		{  H263Free(DstWindow); return(0); }



    initbits();
    temp_ref = 0;
    prev_temp_ref -1; 
    while (getheader()) 
    {
      getpicture(&framenum);
      framenum++;
    }
	if (Dst!=NULL)
	for (v=0,i=0;v<vertical_size;v++)
	{
		if (v>119) continue;

		for (h=0;h<horizontal_size;h++)
		{
			if (h>159) continue;
		*(Dst+i) = DitherData_[h+(v*horizontal_size)];
		i++;
		}
	}

return 0;
}

void initdecoder(int ColorDepth)
{
  int i, cc, size;
  FILE *cleared;
   ld=(struct _ld*)calloc(1,sizeof(struct _ld));

  /* clip table */
  if (clp==NULL)
  clp=(unsigned char *)calloc(1024,sizeof(unsigned char));

  clp += 384;

  for (i=-384; i<640; i++)
    clp[i] = (i<0) ? 0 : ((i>255) ? 255 : i);
  /* MPEG-1 = TMN parameters */
  matrix_coefficients = 5;


  horizontal_size = 160;
  horizontal_size = 176;
  /* this may have to be 128 ???? */
  vertical_size = 120; /* this is the real size */
  vertical_size = 144; /* this is a test value */


  mb_width = horizontal_size/16;
  mb_height = vertical_size/16;
  coded_picture_width = horizontal_size;
  coded_picture_height = vertical_size;
  chrom_width =  coded_picture_width>>1;
  chrom_height = coded_picture_height>>1;
  blk_cnt = 6;
#ifdef NEVER
  for (cc=0; cc<3; cc++) 
  {
    if (cc==0)
      size = coded_picture_width*coded_picture_height;
    else
      size = chrom_width*chrom_height;

    if (!(refframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");

    if (!(oldrefframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");

    if (!(bframe[cc] = (unsigned char *)malloc(size)))
      error("malloc failed\n");
  }
#endif
  for (cc=0; cc<3; cc++) 
  {
    if (cc==0) 
    {
      size = (coded_picture_width+64)*(coded_picture_height+64);
      if (!(edgeframeorig[cc] = (unsigned char *)malloc(size)))
        error("malloc failed\n");
      edgeframe[cc] = edgeframeorig[cc] + (coded_picture_width+64) * 32 + 32;
    }
    else 
    {
      size = (chrom_width+32)*(chrom_height+32);
      if (!(edgeframeorig[cc] = (unsigned char *)malloc(size)))
        error("malloc failed\n");
      edgeframe[cc] = edgeframeorig[cc] + (chrom_width+32) * 16 + 16;
    }
  }

  if (expand) 
  {
    for (cc=0; cc<3; cc++) 
    {
      if (cc==0)
        size = coded_picture_width*coded_picture_height*4;
      else
        size = chrom_width*chrom_height*4;
      
      if (!(exnewframe[cc] = (unsigned char *)malloc(size)))
        error("malloc failed\n");
    }
  }

  /* IDCT */
if (refidct)
  init_idctref();
else
  init_idct();

init_display(ColorDepth);
}

void error(text)
char *text;
{
  fprintf(stderr,text);
  exit(1);
}

/* trace output */
void printbits(code,bits,len)
int code,bits,len;
{
  int i;
  for (i=0; i<len; i++)
    printf("%d",(code>>(bits-1-i))&1);
}

static void H263Calloc(int i)
{
printf("H263Calloc\n");
        WindowData[i] = 1;
        VideoFrameData[i].Raw[0]=(unsigned char *)calloc(4096*19,1);
        VideoFrameData[i].refframe[0]=VideoFrameData[i].Raw[0];     
        VideoFrameData[i].oldrefframe[0]=(VideoFrameData[i].Raw[0]+25344);
        VideoFrameData[i].bframe[0]=(VideoFrameData[i].Raw[0]+50688);

        VideoFrameData[i].Raw[1] = (unsigned char *)calloc(10*4096,1);
        VideoFrameData[i].refframe[1] = VideoFrameData[i].Raw[1];
        VideoFrameData[i].oldrefframe[1] = (VideoFrameData[i].Raw[1]+6334);
        VideoFrameData[i].bframe[1] = (VideoFrameData[i].Raw[1]+12668);

        VideoFrameData[i].refframe[2] = (VideoFrameData[i].Raw[1]+19002);
        VideoFrameData[i].oldrefframe[2] = (VideoFrameData[i].Raw[1]+25336);
        VideoFrameData[i].bframe[2] = (VideoFrameData[i].Raw[1]+31670);
return;
}
static void H263Free(int window)
{
printf("H263Free\n");
if (VideoFrameData[window].bframe[0]!=NULL)
{
	free(VideoFrameData[window].Raw[1]);
	free(VideoFrameData[window].Raw[0]);
	VideoFrameData[window].refframe[0]=NULL;
	VideoFrameData[window].oldrefframe[0]=NULL;
	VideoFrameData[window].bframe[0]=NULL;
}
	WindowData[window]=0;
return;
}
