#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "config.h"
#include "tmndec.h"
#include "global.h"


/* private prototypes */
static void display_image (XImage *ximage, unsigned char *dithered_image);
unsigned char *DitherData_;

/* display related data */
static unsigned char *dithered_image;
static int dpy_depth;
XColor *H263Clr;
unsigned char *H263Pixel;

extern void myDither(unsigned char *src);
void init_display(int);

/* init the various conversion tables */
void init_display(int ColorDepth)
{
  int crv, cbu, cgu, cgv;
  int y, u, v, r, g, b;
  int i,k;
  char dummy;

	dpy_depth=ColorDepth;

  if (ColorDepth == 8) 
  {

	H263Clr=(XColor*)calloc(256,sizeof(XColor));
	H263Pixel=(unsigned char*)calloc(256,sizeof(unsigned char));
    /* matrix coefficients */
    crv = convmat[matrix_coefficients][0];
    cbu = convmat[matrix_coefficients][1];
    cgu = convmat[matrix_coefficients][2];
    cgv = convmat[matrix_coefficients][3];

    /* color allocation:
     * i is the (internal) 8 bit color number, it consists of separate
     * bit fields for Y, U and V: i = (yyyyuuvv), we don't use yyyy=0000
     * yyyy=0001 and yyyy=1111, this leaves 48 colors for other applications
     *
     * the allocated colors correspond to the following Y, U and V values:
     * Y:   40, 56, 72, 88, 104, 120, 136, 152, 168, 184, 200, 216, 232
     * U,V: -48, -16, 16, 48
     *
     * U and V values span only about half the color space; this gives
     * usually much better quality, although highly saturated colors can
     * not be displayed properly
     *
     * translation to R,G,B is implicitly done by the color look-up table
     */
    for (i=32; i<240; i++) 
    {
      /* color space conversion */
      y = 16*((i>>4)&15) + 8;
      u = 32*((i>>2)&3)  - 48;
      v = 32*(i&3)       - 48;

      y = 76309 * (y - 16); /* (255/219)*65536 */
	/* ok NOW WHAT ?????? */      
      r = clp[(y + crv*v + 32768)>>16];
      g = clp[(y - cgu*u -cgv*v + 32768)>>16];
      b = clp[(y + cbu*u + 32786)>>16];

	H263Clr[i].red=r;
	H263Clr[i].green=g;
	H263Clr[i].blue=b;
	H263Pixel[i] = i;
	/* we need to load the pixel array with the
		colormap info. Here we need to find the closest
		colors to what we have alloced for MJPEG.
		here is old code snipet:
		xcolor.red = r<< 8;
		xcolor.green = g<<8;
		xcolor.blue = b<<8;
		if (XAllocColor(display, cmap, &xcolor) != 0)
        	pixel[i] = xcolor.pixel;

	  As you can see its a mapping function. I have provided a 
	  function call that allows the application colormap to
	  be copied into pixel. 
		LoadPixelArray(unsigned char ColorNumber,int IndexIntoArray );
		AJM sept 8 1999 */

    }
  ord4x4_dither_init();
  } /* end if depth == 8 */

	if (dithered_image==NULL)
	{
	int n;
		n=coded_picture_width*coded_picture_height;
		if (dpy_depth > 8)
		i=sizeof(int);
		else 
		i=sizeof(unsigned char);

	DitherData_=dithered_image=(unsigned char *)calloc(n,i);
	}

}

void dither(unsigned char *src[])
{
	/* dithered_image is return
		data ready to be displayed
	*/
	/* defined if we have 3 color planes 
		enable thru out the application.
	*/
  if (dpy_depth == 24 || dpy_depth == 32) 
  {
#ifdef PLANES
    if (ximage->bits_per_pixel == 24)
      ConvertYUVtoRGB(src[0],src[1],src[2], dithered_image,
		      coded_picture_width,
		      coded_picture_height);
    else
#endif
      Color32DitherImage(src, dithered_image);
  }  
  else if (dpy_depth == 16) 
  {
    Color16DitherImage(src, dithered_image);
  }
  else 
  {
    ord4x4_dither_frame(src, dithered_image);
	myDither(dithered_image); 
  }

}

