
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <xil/xil.h>
#include "config.h"
#include "tmndec.h"
#include "global.h"

#define LASTPIXELAVAIL 200


extern XColor *H263Clr;
extern unsigned char *H263Pixel;
static XColor *DisplayMap;
static unsigned char *DisplayPixel;
/* ***************** MYDITHER ************* */
extern XilSystemState SystemState;
static XilColorspace rgb_space;
static XilColorspace yuv_space;
static XilImage yuv_image;
static XilImage rgb_image;
static XilImage tmp_image;
static XilMemoryStorage storage;
static XilMemoryStorage storage2;
static unsigned char *SrcImage;
extern XilDitherMask dmask;
static XilDitherMask Dmask;
extern XilLookup colorcube;
static XilLookup ColorCube;
extern XilLookup yuvtorgb;
extern float ScaleXil[3], OffsetXil[3];
static int d,mind,closest;
static int r2,b2,g2;
static unsigned char *v422;
static unsigned char *u422;
static unsigned char *v444;
static unsigned char *u444;
/* **************************************** */

static unsigned char ytab[16 * (256 + 16)];
static unsigned char uvtab[256 * 269 + 270];
void LoadPixelArray(XColor * ,int );
void myDither(unsigned char *src);
static void conv422to444(unsigned char *,unsigned char *);
static void conv420to422(unsigned char *,unsigned char *);

/****************************************************************************

  4x4 ordered dither

  Threshold pattern:

     0  8  2 10
    12  4 14  6
     3 11  1  9
    15  7 13  5
 
 ****************************************************************************/
void LoadPixelArray(XColor *clr,int index)
{
static int Once;
	if (!Once)
	{
	DisplayPixel=(unsigned char *)calloc(256,sizeof(unsigned char));
	DisplayMap=(XColor*)calloc(256,sizeof(XColor));
	}

	for (Once=0;Once<256;Once++)
	{
	memmove((DisplayMap+Once),(clr+Once),sizeof(XColor));
	(DisplayMap+Once)->red = (DisplayMap+Once)->red>>8;
	(DisplayMap+Once)->green = (DisplayMap+Once)->green>>8;
	(DisplayMap+Once)->blue = (DisplayMap+Once)->blue>>8;
	DisplayPixel[Once]= (DisplayMap+Once)->pixel;
	}
}
/* just for test i use 32 orig value is 0 AJM */
void ord4x4_dither_init (void)
{
int width, height, cwidth;
int multipliers[25];
unsigned int dimensions[25];
short int origin;
int i;

	width = coded_picture_width;
      	height = coded_picture_height;

	v422=(unsigned char *)malloc(16384);
        u422=(unsigned char *)malloc(16384);
        v444=(unsigned char *)malloc(16384*2);
        u444=(unsigned char *)malloc(16384*2);


	yuv_space=xil_colorspace_get_by_name(SystemState,"ycc601");
	yuv_image=xil_create(SystemState,width,height,3,XIL_BYTE);
	xil_set_colorspace(yuv_image,yuv_space);	
	tmp_image=xil_create(SystemState,width,height,1,XIL_BYTE);


}
void
ord4x4_dither_frame (unsigned char *src[], unsigned char *dst)
{
  static int Once;
  int i,m;
  unsigned char *py = src[0];
  unsigned char *pu;
  unsigned char *pv;
  int WidthHeight;

	WidthHeight = coded_picture_width*coded_picture_height;

        conv420to422(src[1],u422);
        conv420to422(src[2],v422);
        conv422to444(u422,u444);
        conv422to444(v422,v444);
        pu=u444;
        pv=v444;

	xil_export(yuv_image);
	if (!Once)
	xil_get_memory_storage(yuv_image,&storage);

	for (i=0,m=0;i<WidthHeight;i++)
	{
		storage.byte.data[m]   = *py;
		storage.byte.data[m+1] = *pu;
		storage.byte.data[m+2] = *pv;
		m += 3;
		py++;
		pu++;
		pv++;
	}

	xil_import(yuv_image,TRUE); 
	xil_ordered_dither(yuv_image,tmp_image,colorcube,dmask);
	if (!Once)
	xil_export(tmp_image);
	xil_get_memory_storage(tmp_image,&storage2);

	for (i=0;i<WidthHeight;i++)
	*(dst+i) = storage2.byte.data[i];
	Once=1;

return;		
}

void myDither(unsigned char *src)
{
return;
}
/* vertical 1:2 interpolation filter */
static void conv420to422(unsigned char *src,unsigned char *dst)
{
  int w, h, i, j, j2;
  int jm3, jm2, jm1, jp1, jp2, jp3;

  w = coded_picture_width>>1;
  h = coded_picture_height>>1;

  /* intra frame */
  for (i=0; i<w; i++) {
    for (j=0; j<h; j++) {
      j2 = j<<1;
      jm3 = (j<3) ? 0 : j-3;
      jm2 = (j<2) ? 0 : j-2;
      jm1 = (j<1) ? 0 : j-1;
      jp1 = (j<h-1) ? j+1 : h-1;
      jp2 = (j<h-2) ? j+2 : h-1;
      jp3 = (j<h-3) ? j+3 : h-1;

      /* FIR filter coefficients (*256): 5 -21 70 228 -37 11 */
      /* New FIR filter coefficients (*256): 3 -16 67 227 -32 7 */
      dst[w*j2] =     clp[(int)(  3*src[w*jm3]
          -16*src[w*jm2]
          +67*src[w*jm1]
          +227*src[w*j]
          -32*src[w*jp1]
          +7*src[w*jp2]+128)>>8];

      dst[w*(j2+1)] = clp[(int)(  3*src[w*jp3]
          -16*src[w*jp2]
          +67*src[w*jp1]
          +227*src[w*j]
          -32*src[w*jm1]
          +7*src[w*jm2]+128)>>8];
    }
    src++;
    dst++;
  }
}
/* horizontal 1:2 interpolation filter */
static void conv422to444(unsigned char *src,unsigned char *dst)
{
  int i, i2, w, j, im3, im2, im1, ip1, ip2, ip3;

  w = coded_picture_width>>1;

  for (j=0; j<coded_picture_height; j++) {
    for (i=0; i<w; i++) {

      i2 = i<<1;
      im3 = (i<3) ? 0 : i-3;
      im2 = (i<2) ? 0 : i-2;
      im1 = (i<1) ? 0 : i-1;
      ip1 = (i<w-1) ? i+1 : w-1;
      ip2 = (i<w-2) ? i+2 : w-1;
      ip3 = (i<w-3) ? i+3 : w-1;

      /* FIR filter coefficients (*256): 5 -21 70 228 -37 11 */
      dst[i2] =   clp[(int)(  5*src[im3]
              -21*src[im2]
              +70*src[im1]
              +228*src[i]
              -37*src[ip1]
              +11*src[ip2]+128)>>8];

      dst[i2+1] = clp[(int)(  5*src[ip3]
              -21*src[ip2]
              +70*src[ip1]
              +228*src[i]
              -37*src[im1]
              +11*src[im2]+128)>>8];
    }
    src+= w;
    dst+= coded_picture_width;
  }
}
